<?php 

function verifica_quadra($quadra, $empreendimento){
    include "conexao.php";

    $query = mysqli_query($db, "SELECT idproduto FROM produto WHERE empreendimento_idempreendimento = '$empreendimento' AND quadra = '$quadra' ");

    $executa_query = mysqli_fetch_assoc($query);

    if(empty($executa_query)){
        return false;
    }else{
        return $executa_query['idproduto'];
    }
}

function formata_lote($lote){
    $aux = strlen($lote);

    for($i = 1; $i < 10; $i++){
        $aux1 = str_replace(('-'.$i), ('-0'.$i), $lote);

        if(strlen($aux1) > $aux){
            break;
        }
    }
    return $aux1;
}

function formata_m2($m2){
    return str_replace(',', '.', $m2);
}

function formata_valor($valor){
    $aux = explode(" ", $valor);


    /*    $aux = explode(".", $aux[1]);

        $aux = str_replace('.', '', $aux[0]);
        $aux = str_replace(',', '.', $aux);
    */

    return $aux[1];
}

function verifica_lote($idquadra, $lote){
    include "conexao.php";

    $query = mysqli_query($db, "SELECT idlote FROM lote WHERE produto_idproduto = $idquadra AND lote = '$lote' ")or die(mysqli_error($db));

    $executa_query = mysqli_fetch_assoc($query);

    if(empty($executa_query)){
        return false;
    }else{
        return $executa_query['idlote'];
    }
}


function update_mld_lote($arquivo, $empreendimento){// Passando o caminho do arquivo

    include "conexao.php";

    $retorno["ok"] = Array();

    // If you need to parse XLS files, include php-excel-reader
    require('spreadsheet-reader-master/PHPExcel.php');
    require('spreadsheet-reader-master/php-excel-reader/excel_reader2.php');
    require('spreadsheet-reader-master/SpreadsheetReader.php');


    $tabela_erro = new PHPExcel();
    $colunas = ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q","R"];

    $Reader = new SpreadsheetReader($arquivo); // Crio o objeto do arquivo
    $Sheets = $Reader -> Sheets(); // Obtenho as planilhas do arquivo

    foreach ($Sheets as $Index => $Name){// Para percorrer as planilhas do arquivo
        $aux_erro = 2;
        $Reader -> ChangeSheet($Index);  // Habilito a página atual para edição

        foreach ($Reader as $registro => $linha ){  //Para percorrer as linhas dentro da planilha

            $cont = 0;

            //Verifico se a linha está completamente vazia 
            foreach ($linha as $valor) {
                if(empty($valor)){
                    $cont++;
                }
            }

            //Se a linha estiver vazia o script para a varredura
            if($cont == 16 && $registro > 5){
                break;
            }

           
            //Esse bloco verifica o titulo da planilha
            if ($registro == 0) {
                $aux = 0;
                foreach ($linha as $valor) {
                    if ($valor == "TABELA PARA CADASTRO DE LOTES") {
                        $aux = 1;
                    }
                }
                if ($aux !== 1) {
                    break;
                }
            }

            if($registro == 4){
                for($i = 0; $i < count($linha); $i++){
                    $tabela_erro->setActiveSheetIndex(0)->setCellValue("".$colunas[$i]."1", $linha[($i)]);
                }
            }


        
            // Verifico se já passou as linhas de informação no começo do arquivo
            if ($registro > 5){

                // Validação dos dados da linha atual, segue abaixo os Index de cada coluna dentro da $linha
                // quadra = 0           direito = 6             cdireita = 12           
                // lote = 1             esquerdo = 7            cesquerda = 13
                // m2 = 2               frente = 8              coutros = 14            
                // status = 3           fundo = 9               moutros =15   
                // endereco = 4         cfrente = 10
                // matricula = 5        cfundo = 11     
                
                $problema = '';
                $lote;
                $valida = 1;
                for($i = 0; $i < count($linha); $i++){

                    // Validação da quadra
                    if ($i == 0) {  
                        if (empty($linha[$i])) {
                            $valida = 0;
                            $problema = "Quadra invalida";
                            break;
                        }else{
                            $lote['quadra'] = ($linha[$i]);
                        }
                    }

                    // Validação do Lote
                    elseif ($i == 1) {
                        if (empty($linha[$i])) {
                            $valida = 0;
                            $problema = "Lote invalido";
                            break;
                        }else{
                            $lote['lote'] = ($linha[$i]);
                        }
                    }

                    // armazenamento tamanho direito do lote
                    elseif ($i == 6) {
                        if (!empty($linha[$i])) {
                            $lote["direito"] = formata_m2($linha[$i]);
                            $aux_dir = $lote['direito'];
                        }else{
                            $lote["direito"] = "";
                        }
                    }

                }
                
                if ($valida == 1) {

                    //var_dump($lote);
                    //die();
                    // Faço a verificação se o lote já existe no banco de dados se não existir eu ja crio
                    if(verifica_quadra($lote['quadra'], $empreendimento) === false){
                        echo "quadra não encontrada";
                        die();
                    }else{
                        $id_quadra = verifica_quadra($lote['quadra'], $empreendimento);

                        if(verifica_lote($id_quadra, $lote['lote']) !== false){
                            $id_lote = verifica_lote($id_quadra, $lote['lote']);
                        }else{
                            echo "Lote não encontrado";
                            die();
                        }
                    }   

                    $query = "UPDATE lote SET direita = '$aux_dir' WHERE idlote = $id_lote";
                    //echo $query;

                    $query = mysqli_query($db, "UPDATE lote SET direita = '$aux_dir' WHERE idlote = $id_lote")or die(mysqli_error($db));

                    array_push($retorno['ok'], $registro);
                }else{  

                    // Insere as linha incorretas na tabela de erros
                    for($i = 0; $i <= count($linha); $i++){
                        if($i == count($linha)){
                            $tabela_erro->setActiveSheetIndex(0)->setCellValue("".$colunas[$i].$aux_erro."", $problema);
                            break;
                        }
                        $tabela_erro->setActiveSheetIndex(0)->setCellValue("".$colunas[$i].$aux_erro."", $linha[($i)]);
                    }
                    $aux_erro++;

                    $retorno["error"] = 1;
                }
            }
        }


    }

    $file = $objWriter = PHPExcel_IOFactory::createWriter($tabela_erro, 'Excel2007');
    $file->save("planilhas/falhas_lotes.xlsx");


    echo "acabou";
    if(isset($retorno['ok'])){
        echo "\nLINHAS GRAVADAS: ".count($retorno['ok']);
    }elseif(isset($retorno['error'])){
         echo "\n\nLINHAS NÃO GRAVADAS: ".count($retorno['error']);
    }


    return $retorno;
}

class Upload
{
    var $tipo;
    var $nome;
    var $tamanho;
     
    function Upload(){
    //Criando objeto
    }
     
    function UploadArquivo($arquivo, $pasta){ 
        if(isset($arquivo)){
            $nomeOriginal = $arquivo["name"]; 
            $tamanho = $arquivo["size"];
             
            if (move_uploaded_file($arquivo["tmp_name"], $pasta . $nomeOriginal)){ 

                $this->nome=$pasta . $nomeOriginal;
                $this->tamanho=number_format($arquivo["size"]/1024, 2) . "KB";
                return true; 
            }else{ 
                return false;
            } 
        }
    } 
}

if(isset($_FILES["clientes"])){

    $empreendimento = $_POST['id_empreendimento'];


    $upArquivo = new Upload;
    if($upArquivo->UploadArquivo($_FILES["clientes"], "planilhas/"))
    {   
        $nome = $upArquivo->nome;
        $tamanho = $upArquivo->tamanho;
        $caminho = "planilhas/".$nome;
        $resultado = update_mld_lote($nome, $empreendimento); // recebo os dados da gravação
        $aux = 1;
    }else{
        $aux = 5;
    }

    unlink($nome);
}

?>

<!DOCTYPE html>
<html>
<head>
    <title>alindo</title>
</head>
<body>
    <form class="form-action" action="up_lote.php" method="POST" enctype="multipart/form-data" name="envia_xlsx">
        <div class="modal-body">
            <div class="form-group">
                <label for="exampleFormControlFile1"> Selecione seu arqiuvo .xlsx</label>
                <input type="hidden" name="MAX_FILE_SIZE" value="30000000" required="required">
                <input name="clientes" type="file" class="form-control-file" id="exampleFormControlFile1" required="required">
                <input type="text" name="id_empreendimento">
            </div>
        </div>
        <div class="modal-footer">
            <input type="submit" name="cadastrar" value="Cadastrar" class="btn btn-success"/>
        </div>
    </form>
</body>
</html>