<?php

ini_set('max_execution_time', 0);

function solicitaToken($chave_master)
{
    $ch = curl_init("https://cobrancaonline.sicredi.com.br/sicredi-cobranca-ws-ecomm-api/ecomm/v1/boleto/autenticacao");

    $header    = [];
    $header[] = 'Content-Type:application/json';
    $header[] = 'token: ' . $chave_master;

    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $retorno = curl_exec($ch);


    curl_close($ch);
    $retorno = json_decode($retorno, true);

    //var_dump($retorno);


    return $retorno;
}

function modulo_11($num, $base = 9, $r = 0)
{
    /**
     *   Autor:
     *           Pablo Costa <pablo@users.sourceforge.net>
     *
     *   Função:
     *    Calculo do Modulo 11 para geracao do digito verificador 
     *    de boletos bancarios conforme documentos obtidos 
     *    da Febraban - www.febraban.org.br 
     *
     *   Entrada:
     *     $num: string numérica para a qual se deseja calcularo digito verificador;
     *     $base: valor maximo de multiplicacao [2-$base]
     *     $r: quando especificado um devolve somente o resto
     *
     *   Saída:
     *     Retorna o Digito verificador.
     *
     *   Observações:
     *     - Script desenvolvido sem nenhum reaproveitamento de código pré existente.
     *     - Assume-se que a verificação do formato das variáveis de entrada é feita antes da execução deste script.
     */

    $soma = 0;
    $fator = 2;

    /* Separacao dos numeros */
    for ($i = strlen($num); $i > 0; $i--) {
        // pega cada numero isoladamente
        $numeros[$i] = substr($num, $i - 1, 1);
        // Efetua multiplicacao do numero pelo falor
        $parcial[$i] = $numeros[$i] * $fator;
        // Soma dos digitos
        $soma += $parcial[$i];
        if ($fator == $base) {
            // restaura fator de multiplicacao para 2 
            $fator = 1;
        }
        $fator++;
    }

    /* Calculo do modulo 11 */
    if ($r == 0) {
        $soma *= 10;
        $digito = $soma % 11;
        return $digito;
    } elseif ($r == 1) {
        // esta rotina sofrer algumas alterações para ajustar no layout do SICREDI
        $r_div = (int) ($soma / 11);
        $digito = ($soma - ($r_div * 11));
        return $digito;
    }
}

function digitoVerificador_nossonumero($numero)
{
    $resto2 = modulo_11($numero, 9, 1);
    // esta rotina sofrer algumas alterações para ajustar no layout do SICREDI
    $digito = 11 - $resto2;
    if ($digito > 9) {
        $dv = 0;
    } else {
        $dv = $digito;
    }
    return $dv;
}

function formata_numero($numero, $loop, $insert, $tipo = "geral")
{
    if ($tipo == "geral") {
        $numero = str_replace(",", "", $numero);
        while (strlen($numero) < $loop) {
            $numero = $insert . $numero;
        }
    }
    if ($tipo == "valor") {
        /*
			retira as virgulas
			formata o numero
			preenche com zeros
			*/
        $numero = str_replace(",", "", $numero);
        while (strlen($numero) < $loop) {
            $numero = $insert . $numero;
        }
    }
    if ($tipo == "convenio") {
        while (strlen($numero) < $loop) {
            $numero = $numero . $insert;
        }
    }
    return $numero;
}

function monitoraTitulo($sicredi, $nossonumero = '', $data = '')
{

    if ($data != '') {
        $ch = curl_init("https://cobrancaonline.sicredi.com.br/sicredi-cobranca-ws-ecomm-api/ecomm/v1/boleto/consulta?agencia=" . $sicredi['agencia'] . "&cedente=" . $sicredi['cedente'] . "&nossoNumero=" . $nossonumero . "&posto=" . $sicredi['posto'] . "&dataInicio=" . $data['dataInicio'] . "&dataFim=" . $data['dataFim'] . "&tipoData=" . $data['tipoData']);
    } else {
        $ch = curl_init("https://cobrancaonline.sicredi.com.br/sicredi-cobranca-ws-ecomm-api/ecomm/v1/boleto/consulta?agencia=" . $sicredi['agencia'] . "&cedente=" . $sicredi['cedente'] . "&nossoNumero=" . $nossonumero . "&posto=" . $sicredi['posto']);
    }

    $header   = [];
    $header[] = 'Content-Type:application/json';
    $header[] = 'token: ' . $sicredi['token'];

    curl_setopt($ch, CURLOPT_POST, false);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $retorno = curl_exec($ch);
    curl_close($ch);

    $retorno = json_decode($retorno, true);

    //var_dump($retorno);

    return $retorno;
}

function verifica_ja_pagou($id, $db)
{
    $query = mysqli_query($db, "SELECT * FROM `parcelas` 
                                WHERE `venda_idvenda` = $id 
                                AND fluxo = '0'
                                AND situacao = 'Pago' 
                                AND tipo_venda = '2'") or die(mysqli_error($db));

    $total = mysqli_num_rows($query);

    return $total;
}

function consulta_cliente($id, $db)
{
    $query = mysqli_query($db, "SELECT * FROM `cliente` WHERE `idcliente` = $id") or die(mysqli_error($db));

    if (mysqli_num_rows($query)) {
        $assoc = mysqli_fetch_assoc($query);

        return $assoc['nome_cli'];
    } else {
        return false;
    }
}

function altera_lote($id, $db)
{
    $query = mysqli_query($db, "SELECT * FROM `parcelas` 
									INNER JOIN venda ON parcelas.venda_idvenda = venda.idvenda
									WHERE `idparcelas` = $id");

    if (mysqli_num_rows($query)) {
        $assoc = mysqli_fetch_assoc($query);

        return $assoc;
    } else {
        return false;
    }
}

function valor_vinculo($vinculo)
{

    $hostname = '162.144.80.34';
    $username = 'herminio_pro';
    $senha = 'si171156';
    $banco = 'herminio_pro';
    $db = @mysqli_connect($hostname, $username, $senha, $banco) or die(mysqli_error($db));
    @mysqli_select_db($banco, $db);


    $select_vinculo = mysqli_query($db, "SELECT SUM(valor_parcelas) as total_parcelas, SUM(juros_multa) as total_multa, SUM(juros_mora) as total_mora, SUM(juros_outros) as total_outros, SUM(desc_parcela) as total_desc FROM parcelas
			WHERE vinculo = '$vinculo'");

    while ($result_vinculo = mysqli_fetch_assoc($select_vinculo)) {

        $total_parcelas = $result_vinculo["total_parcelas"];
        $total_multa    = $result_vinculo["total_multa"];
        $total_mora     = $result_vinculo["total_mora"];
        $total_outros   = $result_vinculo["total_outros"];
        $total_desc     = $result_vinculo["total_desc"];

        $total = ($total_parcelas + $total_multa + $total_mora + $total_outros) - $total_desc;
    }

    return $total;
}

function verificarVinculo($idparcela)
{
    $hostname = '162.144.80.34';
    $username = 'herminio_pro';
    $senha = 'si171156';
    $banco = 'herminio_pro';
    $db = @mysqli_connect($hostname, $username, $senha, $banco) or die(mysqli_error($db));
    @mysqli_select_db($banco, $db);

    $query = "SELECT vinculo FROM parcelas  WHERE idparcelas = '$idparcela'";
    //echo $query;


    $executa = mysqli_query($db, $query) or die("erro ao listar numero do vinculo");

    $busca = mysqli_fetch_assoc($executa);
    $vinculo = $busca['vinculo'];


    return $vinculo;
}

function pegaParcelasVinculo($vinculo)
{

    $hostname = '162.144.80.34';
    $username = 'herminio_pro';
    $senha = 'si171156';
    $banco = 'herminio_pro';
    $db = @mysqli_connect($hostname, $username, $senha, $banco) or die(mysqli_error($db));
    @mysqli_select_db($banco, $db);
    //echo "entrei na funçao";

    $query = "SELECT idparcelas FROM parcelas WHERE vinculo = '$vinculo' AND fluxo = 0";
    //echo $query;

    $executa = mysqli_query($db, $query) or die("erro ao listar parcelas vinculadas");

    while ($busca1 = mysqli_fetch_assoc($executa)) {

        $parcelas[] = $busca1['idparcelas'];
    }

    return $parcelas;
}

function change_key($array, $old_key, $new_key)
{

    if (!array_key_exists($old_key, $array))
        return $array;

    $keys = array_keys($array);
    $keys[array_search($old_key, $keys)] = $new_key;

    return array_combine($keys, $array);
}

//Conexao para o banco padrão	
$hostname = '162.144.80.34';
$username = 'herminio_pro';
$senha = 'si171156';
$banco = 'herminio_pro';
$db = @mysqli_connect($hostname, $username, $senha, $banco) or die(@mysqli_error($db));
@mysqli_select_db($banco, $db);

//Conexaõ para o banco da api de boletos
$hostname_boleto = '162.144.80.34';
$username_boleto = 'furlan_boleto';
$senha_boleto = 'si171156';
$banco_boleto = 'furlan_api_boleto';
$db_boleto = @mysqli_connect($hostname_boleto, $username_boleto, $senha_boleto, $banco_boleto) or die(@mysqli_error($db));
@mysqli_select_db($banco_boleto, $db_boleto);

//Realizo a consulta dos dados da conta
$query = mysqli_query($db, "SELECT * FROM `contacorrente` WHERE `banco` = '748'") or die(mysqli_error($db));

if (mysqli_num_rows($query)) {
    $assoc = mysqli_fetch_assoc($query);

    $sicredi['agencia']  = $assoc['agencia'];
    $sicredi['cedente']  = $assoc['codigo_cedente'];
    $sicredi['posto']     = $assoc['posto'];

    $conta_master   = $assoc['conta'];
    $agencia_master = $sicredi['agencia'];
    $posto_master   = $sicredi['posto'];

    $chave_master = $assoc['chave_master'];

    $today = date('Y-m-d');
    $today_future = date('Y-m-d', strtotime("-1 month", strtotime($today)));

    $today_format = date('d/m/Y', strtotime($today_future));
    $today_format2 = date('d/m/Y', strtotime($today));


    $query = mysqli_query($db_boleto, "SELECT * FROM `token_sicredi` WHERE `chave_master` = '$chave_master' ") or die(mysqli_error($db_boleto));

    if (mysqli_num_rows($query)) {

        $assoc = mysqli_fetch_assoc($query);
        //echo $today."<br>".$today_future;

        $sicredi['token']    = $assoc['token'];
        $data['dataInicio'] = $today_format;
        $data['dataFim']     = $today_format2;
        $data['tipoData']   = 'DATA_EMISSAO';

        //var_dump($sicredi);
        $aux = monitoraTitulo($sicredi, '', $data);
        //var_dump($aux);
        if ($aux['codigo'] == "E20001") {
            $token = solicitaToken($chave_master);
            $token = $token['chaveTransacao'];

            //echo "CM:".$chave_master;
            var_dump($token);

            $sicredi['token']    = $token;

            mysqli_query($db_boleto, "UPDATE `token_sicredi` SET `token`= '$token' WHERE `chave_master` = '$chave_master'") or die(mysqli_error($db_boleto));
        }
    } else {
        $token = solicitaToken($chave_master);
        $token = $token['chaveTransacao'];

        mysqli_query($db_boleto, "INSERT INTO `token_sicredi`(`chave_master`, `token`) VALUES ('$chave_master','$token')") or die(mysqli_error($db_boleto));
    }

    $corpo_email = "";
    //Faço a consulta por data de baixa

    $data['dataInicio'] = $today_format;
    $data['dataFim']     = $today_format2;
    $data['tipoData']   = 'DATA_LIQUIDACAO';

    $boletos =  monitoraTitulo($sicredi, '', $data);

    if (count($boletos) > 0 && !isset($boletos['codigo'])) {

        $id_boletos = [];


        $boletos_index = $boletos;

        foreach ($boletos as $key => $boleto) {
            $boletos_index = change_key($boletos_index, $key, $boleto['seuNumero']);
            $id_boletos[] = $boleto['seuNumero'];
        }

        $id_boletos = 'IN(' . implode(',', $id_boletos) . ')';

        $query = mysqli_query($db, "SELECT `idparcelas`, `venda_idvenda`, `cliente_id_novo` FROM `parcelas` WHERE `fluxo` = 0 AND `remessa` = 1 AND `valor_recebido` = '' AND `data_recebimento` = '' AND `situacao` = 'Em Aberto' AND idparcelas $id_boletos ORDER BY idparcelas DESC") or die(mysqli_error($db));

        if (mysqli_num_rows($query)) {
            $corpo_email = 'Vendas que voltaram\n\n\n';
            $email_volta_lote = '';
            $codigo_baixa = date('YmdHis');
            $today = date('d-m-Y');

            while ($assoc = mysqli_fetch_assoc($query)) {
                $venda = $assoc['venda_idvenda'];
                $cliente = $assoc['cliente_id_novo'];
                $id_parcela = $assoc['idparcelas'];

                $cliente = consulta_cliente($cliente, $db);

                $data_recebimento = date('d-m-Y', strtotime($boletos_index[$id_parcela]['dataLiquidacao']));
                $valor_recebido = $boletos_index[$id_parcela]['valorLiquidado'];


                $mensagem = 'Ola recebemos um novo Pagamento no Valor de R$ ' . $valor_recebido . ' , na data de ' . $data_recebimento . ' , do cliente ' . $cliente;

                $corpo_email .= $mensagem . "\n\n";

                $mensagem = str_replace(' ', '+', $mensagem);


                // Codigo para aprovar a venda e colocar o lote vermelho
                $verifica_ja_pagou = verifica_ja_pagou($venda, $db);

                $altera_lote = altera_lote($assoc['idparcelas'], $db);

                $id_da_venda = $altera_lote["idvenda"];
                $id_do_lote  = $altera_lote["lote_idlote"];


                if ($verifica_ja_pagou === 0) {

                    $email_volta_lote .= "Venda passada pra func: ".$venda." Vardump do DB: ".var_dump($db)." Retorno da func: ".$verifica_ja_pagou." Id dos lotes: " . $id_do_lote . " Id da venda: " . $id_da_venda . "\n\n";

                    $atualiza_venda = mysqli_query($db, "UPDATE venda SET status_venda = '2' where idvenda = $id_da_venda");
                    $atualiza_lote = mysqli_query($db, "UPDATE lote SET status = '2' where idlote = $id_do_lote");
                }

                ////////////////////////////////////////////////////////
                // var_dump($email_volta_lote);
                $vinculo = verificarVinculo($assoc['idparcelas']);

                if ($vinculo != '') {
                    $parcelas_master = pegaParcelasVinculo($vinculo);

                    $acre_master = ($valor_recebido - valor_vinculo($vinculo));

                    mysqli_query($db, "UPDATE `parcelas` SET `acre_parcela`= '$acre_master' WHERE `idparcelas` = '" . $assoc['idparcelas'] . "' ") or die(mysqli_error($db));

                    foreach ($parcelas_master as $key => $value) {
                        mysqli_query($db, "UPDATE `parcelas` SET `situacao`= 'Pago', `data_recebimento`= '$data_recebimento' ,`valor_recebido`= `valor_parcelas`,`cod_baixa`= '$codigo_baixa',`data_baixa`='$today' WHERE `idparcelas` = $value ") or die(mysqli_error($db));
                    }
                } else {
                    mysqli_query($db, "UPDATE `parcelas` SET `situacao`= 'Pago',`data_recebimento`= '$data_recebimento' ,`valor_recebido`= '$valor_recebido',`cod_baixa`= '$codigo_baixa',`data_baixa`='$today' WHERE `idparcelas` = '" . $assoc['idparcelas'] . "' ") or die(mysqli_error($db));
                }



                $point = curl_init('send.smsmobile.com.br/recebe_sms.php?user=lucas&numero=16999653730&msg=' . $mensagem);
                $result = curl_exec($point);
                curl_close($point);
            }

            if ($corpo_email != "") {
                mail("financeiro@herminiomoretti.com.br", "RETORNO SICREDI", $email_volta_lote);
                mail("contato@immobilebusiness.com.br", "LOTES QUE VOLTARAM", $corpo_email);
            }
        }
    }
}
