
var session;
var url = 'https://sms.ibsystem.com.br/immobsms/routes/';
//var url = 'http://localhost/sms/routes/';


var payment_form = new DatPayment({
    form_selector: 'form#cartao',
    card_container_selector: '.dpf-card-placeholder',

    number_selector: '.cartao[name="cardNumber"]',
    date_selector: '.cartao[name="cardExpiry"]',
    cvc_selector: '.cartao[name="cardCVC"]',
    name_selector: 'input[name="nomeCartao"]',

    // submit_button_selector: '.botao_cartao',

    placeholders: {
        number: '•••• •••• •••• ••••',
        expiry: '••/••••',
        cvc: '•••',
        name: 'NOME NO CARTÃO'
    },

    validators: {
        number: function(number){
            return Stripe.card.validateCardNumber(number);
        },
        expiry: function(expiry){
            var expiry = expiry.split(' / ');
            return Stripe.card.validateExpiry(expiry[0]||0,expiry[1]||0);
        },
        cvc: function(cvc){
            return Stripe.card.validateCVC(cvc);
        },
        name: function(value){
            return value.length > 0;
        }
    }
});

$.ajax({
	url : url+"pay_session.php",
	type : 'GET',
	// async: false, 
	dataType: 'json',
	success : function(dados){
		session = dados;
	}
})


$('form#cartao').submit(function(e){
	e.preventDefault();

    // Obter identificação do comprador
    var senderHash = PagSeguroDirectPayment.getSenderHash();
	$("input#sendercc").val(senderHash);

	// console.log($('input.telefone').val().replace(/[() -]/g, ''));
	$("input[name='cpf']").val($("input[name='cpf']").val().replace(/[. -]/g, ''));
	$('input.telefone').val($('input.telefone').val().replace(/[() -]/g, ''));
	$("input[name='cep']").val($("input[name='cep']").val().replace(/[-]/g, ''));

	$.ajax({
	    url: url + "pay_creditCard.php",
	    type: 'POST',
	    data: $('form#cartao').serialize(),
	    dataType: 'json',
	    success: function (data) {
	    	if(data.status != "Erro"){
	    		swal("Pedido Efetuado com Sucesso!", "Em breve sua recarga será efetivada", "success");
	    	}else{
	    		swal("Falha ao Realizar o Pagamento!", "Por gentileza tente mais tarde", "error");
	    	}
	    },
	    error: function(data){
	    	swal("Falha ao Realizar o Pagamento!", "Por gentileza tente mais tarde", "error");
	    },
        beforeSend: function(){
	    	swal ({
		    	title: "Carregando, Aguarde ...",
		    	text: "Em instantes aprovaremos seu pagamento",
		    	icon: "loading.gif",
		    	button: false,
		    	closeOnClickOutside: false,
	    	});
	    }
    });
});

$('form#boleto').submit(function(e){
	e.preventDefault();

    // Obter identificação do comprador
    var senderHash = PagSeguroDirectPayment.getSenderHash();
	$("input#senderboleto").val(senderHash);

	$.ajax({
	    url: url + "pay_boleto.php",
	    type: 'POST',
	    data: $('form#boleto').serialize(),
	    dataType: 'json',
	    success: function (data) {
	    	console.log(data);
	    	if(data.status == "Sucesso"){
	    		window.open(data.link_boleto, '_blank');
		    	swal("Boleto Gerado com Sucesso!", "Assim que compensado, sua recarga será efetivada", "success");
	    	}else{
	    		swal("Falha ao Realizar o Pagamento!", "Por gentileza tente mais tarde", "error");
	    	}
	    },
	    error: function(data){
	    	swal("Falha ao Gerar o Boleto!", "Por gentileza tente mais tarde", "error");
	    },
	    beforeSend: function(){
	    	swal ({
		    	title: "Carregando, Aguarde ...",
		    	text: "Em instantes aprovaremos seu pagamento",
		    	icon: "loading.gif",
		    	button: false,
		    	closeOnClickOutside: false,
	    	});
	    }
    });
});


//Faz a validação do cartão para a geração da hash sempre que o usuario perde o foco de um dos campos do cartão.
$('input.cartao').blur(function(){
	var valida = 1;

	// console.log($("input[name='cardExpiry']").val());

	$('input.cartao').each(function(){
		$(this).val() == '' ? valida = 0 : '';
	});

	if(valida){
		jQuery(function($) {
	        // cria uma sessão
	        PagSeguroDirectPayment.setSessionId(session);

	        // obter meios de pagamento
	        PagSeguroDirectPayment.getPaymentMethods({
	        	success: function(json) {
	        		// console.log(json);
	        	},
	        	error: function(json) {
	        		// console.log(json);
	        		var erro = "";
	        		for (i in json.errors) {
	        			erro = erro + json.errors[i];
	        		}
	        		alert(erro);
	        	},
	        	complete: function(json) {}
	        });

	        // consultar a bandeira do cartão
	        PagSeguroDirectPayment.getBrand({
	        	cardBin: $("input[name='cardNumber']").val().replace(/ /g, ''),
	        	success: function(json) {
	        		var brand = json.brand.name;

	        		$("input[name='brand']").val(brand);

	        		// console.log(brand);

	        		var param = {
	        			cardNumber: $("input[name='cardNumber']").val().replace(/ /g, ''),
	        			brand: brand,
	        			cvv: $("input[name='cardCVC']").val(),
	        			expirationMonth: $("input[name='cardExpiry']").val().replace(/ /g, '').split('/')[0],
	        			expirationYear: $("input[name='cardExpiry']").val().replace(/ /g, '').split('/')[1],
	        			success: function(json) {
	        				var token = json.card.token;
	        				$("input[name='token']").val(token);
	        				// console.log("Token: " + token);
	        				// swal("Dados Validados com Sucesso!", "Preencha os dados pessoais para prosseguir!", "success");
	        				$('input[name="nomeCartao"]').focus();
	        			},
	        			error: function(json) {
	        				// console.log(json);
	        				$("input[name='token']").val('');
	        				$("input[name='cardCVC']").val('');

	        				swal("Dados Inválidos!", "Revise seus dados antes de continuar!", "error");
	        			},
	        		}

	                // obter token do cartão de crédito
	                PagSeguroDirectPayment.createCardToken(param);
	            },
	            error: function(json) {
	            	// console.log(json);
	            	
	            	$("input[name='token']").val('');
	            	$("input[name='cardCVC']").val('');

	            	swal("Dados Inválidos!", "Revise seus dados antes de continuar!", "error");

	            },
	            complete: function(json) {}
	        });
	    });
	}
});