<?php
session_start();

if (empty($_SESSION)) {
	die();
}

include '../conexao.php';

$query = mysqli_query($db, "SELECT * FROM `usuario_sms`")or die(mysqli_error($db));
$assoc = mysqli_fetch_assoc($query);
$hash = $assoc['hash'];

require_once('config.php');
require_once('utils.php');
?>
<!DOCTYPE html>
<html lang="pt-br">

<head>
	<meta charset="UTF-8">
	<meta name=”viewport” content=”width=device-width; initial-scale=1.0; maximum-scale=1.0; user-scalable=no;” />

	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css" integrity="sha256-rByPlHULObEjJ6XQxW/flG2r+22R5dKiAoef+aXWfik=" crossorigin="anonymous" />

	<link rel="stylesheet" href="css/custom.css">

</head>

<body>

	<div class="container">
		<div class="row" style="margin-top: 30px;">

			<div class="row" align="center">
				<div class="radio-button radio-blue radio-rounded">
					<input id="chkTest4" type="radio" name="testRadio2" tipo="cc" />
					<label for="chkTest4">Cartão de Crédito</label>
				</div>
				<div class="radio-button radio-blue radio-rounded">
					<input id="chkTest5" type="radio" name="testRadio2" tipo="boleto" checked />
					<label for="chkTest5">Boleto</label>
				</div>
			</div>

			<div class="form-group col-md-12" align="center">
				<label for="qntSMS">Qnt SMS (R$ 0,05)</label>
				<input type="number" class="form-control" name="qntSMS" form="cartao" required placeholder="Digite a quantidade de SMS" />
			</div>

			<!-- PAGAMENTO VIA CARTÃO -->
			<div class="col-md-12 hidden" id="cc">

				<div class="panel panel-default">
					<div class="panel-heading">
						<div class="row" align="center">
							<h3 class="panel-title" style="font-size: 18px; font-weight: bold;">Pague com Cartão de Crédito</h3>
						</div>
					</div>

					<div class="panel-body">
						<form role="form" class="msform" action="#" method="POST" id='cartao'>

							<ul id="progressbar">
								<li class="active">Informações Pessoais</li>
								<li>Informações de Endereço</li>
								<li>Informações de Pagamento</li>
							</ul>

							<fieldset>
								<h2 class="fs-title">Informe seus Dados Pessoais</h2>
								<!-- <h3 class="fs-subtitle">Não se preocupe seu pagamento será processado pelo PagSeguro</h3> -->

								<div class="row">
									<div class="col-xs-12 col-md-12">
										<div class="form-group">
											<label for="cpf">CPF (somente números)</label>
											<input type="text" class="form-control" name="cpf" placeholder="CPF ou CNPJ" required />
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12 col-md-12">
										<div class="form-group">
											<label for="email">E-mail</label>
											<input type="email" class="form-control" name="email" placeholder="exemplo@exemplo.com" required />
										</div>
									</div>
								</div>

								<div class="row">
									<div class="col-xs-6 col-md-6">
										<div class="form-group">
											<label for="telefone">Telefone</label>
											<input type="text" class="form-control telefone" name="telefone" placeholder="(11)99999-9999" required />
										</div>
									</div>

									<div class="col-xs-6 col-md-6">
										<div class="form-group">
											<label for="datanasc">Data Nascimento</label>
											<input type="date" class="form-control" name="datanasc" required />
										</div>
									</div>

								</div>


								<input type="button" name="next" class="next action-button" value="Próximo" />
							</fieldset>

							<fieldset>
								<h2 class="fs-title">Informe seus Dados de Endereço</h2>
								<!-- <h3 class="fs-subtitle">Não se preocupe seu pagamento será processado pelo PagSeguro</h3> -->

								<div class="row">
									<div class="col-xs-6 col-md-6">
										<div class="form-group">
											<label for="cep">CEP</label>
											<input type="text" class="form-control" name="cep" placeholder="Digite o CEP" required />
										</div>
									</div>
									<div class="col-xs-6 col-md-6">
										<div class="form-group">
											<label for="numero">Número</label>
											<input type="number" class="form-control" name="numero" placeholder="Digite o Número" required />
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12 col-md-12">
										<div class="form-group">
											<label for="rua">Rua</label>
											<input type="text" class="form-control" name="rua" placeholder="Digite a Rua" required />
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12 col-md-12">
										<div class="form-group">
											<label for="bairro">Bairro</label>
											<input type="text" class="form-control" name="bairro" placeholder="Digite o Bairro" required />
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-6 col-md-6">
										<div class="form-group">
											<label for="cidade">Cidade</label>
											<input type="text" class="form-control" name="cidade" required />
										</div>
									</div>
									<div class="col-xs-6 col-md-6">
										<div class="form-group">
											<label for="estado">UF</label>
											<input type="text" class="form-control" name="estado" required />
										</div>
									</div>
								</div>


								<input type="button" name="previous" class="previous action-button-previous" value="Anterior" />
								<input type="button" name="next" class="next action-button" value="Próximo" />
							</fieldset>

							<fieldset>

								<input type="hidden" name="brand">
								<input type="hidden" name="token">
								<input type="hidden" name="senderHash" id="sendercc">
								<input type="hidden" name="hash_user" value="<?php echo $hash; ?>">

								<h2 class="fs-title">Informe os Detalhes do Cartão</h2>
								<h3 class="fs-subtitle">Não se preocupe seu pagamento será processado pelo PagSeguro
									<img src="img/pagseguro.png" width="137">
								</h3>

								<div class="row">
									<div class="dpf-card-placeholder"></div>
								</div>


								<div class="row">
									<div class="col-xs-12">
										<div class="form-group">
											<label for="cardNumber">Nº Cartão</label>
											<div class="input-group">
												<input type="tel" class="form-control cartao" name="cardNumber" placeholder="Número de cartão válido" required autofocus />
												<span class="input-group-addon"><i class="glyphicon glyphicon-credit-card"></i></span>
											</div>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-7 col-md-7">
										<div class="form-group">
											<label for="cardExpiry">Validade</label>
											<input type="tel" class="form-control cartao" name="cardExpiry" placeholder="MM/YYYY" required />
										</div>
									</div>
									<div class="col-xs-5 col-md-5 pull-right">
										<div class="form-group">
											<label for="cardCVC">CVV</label>
											<input type="tel" class="form-control cartao" name="cardCVC" placeholder="CVV" required />
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12 col-md-12">
										<div class="form-group">
											<label for="nomeCartao">Nome Impresso no Cartão</label>
											<input type="text" class="form-control" name="nomeCartao" placeholder="EX: José da Silva" required />
										</div>
									</div>
								</div>

								<input type="button" name="previous" class="previous action-button-previous" value="Anterior" />
								<input type="submit" name="submit" class="action-button subscribe btn btn-success btn-lg" value="Pagar" />
								<!-- <div class="col-md-8" align="right">
									<button class="subscribe btn btn-success btn-lg btn-block" type="submit">Pagar</button>
								</div> -->
							</fieldset>

						</form>
					</div>
				</div>
			</div>

			<!-- PAGAMENTO VIA BOLETO -->
			<div class="col-md-12" id="boleto_bancario">

				<div class="panel panel-default">
					<div class="panel-heading">
						<div class="row" align="center">
							<h3 class="panel-title" style="font-size: 18px; font-weight: bold;">Pague com Boleto</h3>
						</div>
					</div>

					<div class="panel-body">
						<form role="form" action="#" method="POST" id="boleto">
							<div class="row">
								<div class="col-xs-12">
									<input type="hidden" name="senderHash" id="senderboleto">
									<input type="hidden" name="hash_user" value="<?php echo $hash; ?>">
									<div class="col-xs-12 col-md-12 pull-right hidden">
										<div class="form-group">
											<label for="qntSMS">Qnt SMS (R$ 0,05)</label>
											<input type="number" class="form-control" name="qntSMS" id="qnt_boleto" required />
										</div>
									</div>
									<button class="subscribe btn btn-success btn-lg btn-block" type="submit">Gerar Boleto</button>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>

		</div>
	</div>


	<!-- API jquery -->
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js" integrity="sha256-KM512VNnjElC30ehFwehXjx1YCHPiQkOPmqnrWtpccM=" crossorigin="anonymous"></script>

	<!-- API bootstrap -->
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>

	<!-- API PagSeguro -->
	<!-- <script type="text/javascript" src="https://stc.sandbox.pagseguro.uol.com.br/pagseguro/api/v2/checkout/pagseguro.directpayment.js"></script> -->
	<script type="text/javascript" src="https://stc.pagseguro.uol.com.br/pagseguro/api/v2/checkout/pagseguro.directpayment.js"></script>

	<!-- API Modal alert -->
	<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
	<script type="text/javascript" src="https://js.stripe.com/v2/"></script>
	<script type="text/javascript" src="js/DatPayment.js"></script>

	<!-- MASK -->
	<script src="//cdnjs.cloudflare.com/ajax/libs/jquery.maskedinput/1.4.1/jquery.maskedinput.min.js"></script>

	<script type="text/javascript" src="js/functions_checkout.js"></script>
	<script type="text/javascript" src="js/functions_wizard.js"></script>
	<script type="text/javascript" src="js/custom.js"></script>

</body>

</html>