<!DOCTYPE html>
<html>
<head>
	<title>alo</title>
</head>
<body>


<script src="https://immobilebusiness.com.br/admin/assets/plugins/jquery/jquery-1.9.1.min.js"></script>
<script src="bc_function.js"></script>
<script type="text/javascript">
	
	function bcadd (left_operand, right_operand, scale) {
	  // http://kevin.vanzonneveld.net
	  // +   original by: lmeyrick (https://sourceforge.net/projects/bcmath-js/)
	  // -    depends on: _phpjs_shared_bc
	  // *     example 1: bcadd(1, 2);
	  // *     returns 1: 3
	  //  @todo: implement these testcases
	  //        bcscale(0);
	  //
	  //        bcmath.test.result('bcadd', 1, '3', bcadd("1", "2"));
	  //        bcmath.test.result('bcadd', 2, '4.0000', bcadd("-1", "5", 4));
	  //        bcmath.test.result('bcadd', 3, '8728932003911564969352217864684.00', bcadd("1928372132132819737213", "8728932001983192837219398127471", 2));
	  //        bcmath.test.result('bcadd', 4, '3.357000', bcadd('1.123', '2.234', 6));
	  var libbcmath = this._phpjs_shared_bc();
	 
	  var first, second, result;
	 
	  if (typeof scale === 'undefined') {
	    scale = libbcmath.scale;
	  }
	  scale = ((scale < 0) ? 0 : scale);
	 
	  // create objects
	  first = libbcmath.bc_init_num();
	  second = libbcmath.bc_init_num();
	  result = libbcmath.bc_init_num();
	 
	  first = libbcmath.php_str2num(left_operand.toString());
	  second = libbcmath.php_str2num(right_operand.toString());
	 
	 
	  result = libbcmath.bc_add(first, second, scale);
	 
	  if (result.n_scale > scale) {
	    result.n_scale = scale;
	  }
	 
	  return result.toString();
	}

	function bcdiv (left_operand, right_operand, scale) {
	    // http://jsphp.co/jsphp/fn/view/bcdiv
	    // +   original by: lmeyrick (https://sourceforge.net/projects/bcmath-js/)
	    // -    depends on: _phpjs_shared_bc
	    // *     example 1: bcdiv(1, 2);
	    // *     returns 1: 3
	    //  @todo: implement these testcases
	    //        bcscale(0);
	    //
	    //        bcmath.test.result('bcdiv', 1, '0', bcdiv("1", "2"));
	    //        bcmath.test.result('bcdiv', 2, '0.50', bcdiv("1", "2", 2));
	    //        bcmath.test.result('bcdiv', 3, '-0.2000', bcdiv("-1", "5", 4));
	    //        bcmath.test.result('bcdiv', 4, '3333.3333', bcdiv("10000.0000", "3", 4));
	    //        bcmath.test.result('bcdiv', 5, '2387.8877', bcdiv("5573.33", "2.334", 4));
	    //        bcmath.test.result('bcdiv', 7, '1.00', bcdiv('6.00', '6.00', 2));
	    //        bcmath.test.result('bcdiv', 8, '1.00', bcdiv('2.00', '2.00', 2));
	    //        bcmath.test.result('bcdiv', 9, '59.51111111', bcdiv('66.95', '1.125', 8));
	    //        bcmath.test.result('bcdiv', 10, '4526580661.75', bcdiv('8728932001983192837219398127471.00', '1928372132132819737213.00', 2));
	    var libbcmath = this._phpjs_shared_bc();

	    var first, second, result;

	    if (typeof(scale) == 'undefined') {
	        scale = libbcmath.scale;
	    }
	    scale = ((scale < 0) ? 0 : scale);

	    // create objects
	    first = libbcmath.bc_init_num();
	    second = libbcmath.bc_init_num();
	    result = libbcmath.bc_init_num();

	    first = libbcmath.php_str2num(left_operand.toString());
	    second = libbcmath.php_str2num(right_operand.toString());

	    result = libbcmath.bc_divide(first, second, scale);
	    if (result === -1) {
	        // error
	        throw new Error(11, "(BC) Division by zero");
	    }
	    if (result.n_scale > scale) {
	        result.n_scale = scale;
	    }
	    return result.toString();
	}

	function bcmul (left_operand, right_operand, scale) {
	    // http://jsphp.co/jsphp/fn/view/bcmul
	    // +   original by: lmeyrick (https://sourceforge.net/projects/bcmath-js/)
	    // -    depends on: _phpjs_shared_bc
	    // *     example 1: bcmul(1, 2);
	    // *     returns 1: 3
	    //  @todo: implement these testcases
	    //        bcscale(0);
	    //
	    //        bcmath.test.result('bcmul', 1, '2', bcmul("1", "2"));
	    //        bcmath.test.result('bcmul', 2, '-15', bcmul("-3", "5"));
	    //        bcmath.test.result('bcmul', 3, '12193263111263526900', bcmul("1234567890", "9876543210"));
	    //        bcmath.test.result('bcmul', 4, '3.75', bcmul("2.5", "1.5", 2));
	    //        bcmath.test.result('bcmul', 5, '13008.1522', bcmul("5573.33", "2.334", 4));
	    var libbcmath = this._phpjs_shared_bc();

	    var first, second, result;

	    if (typeof(scale) == 'undefined') {
	        scale = libbcmath.scale;
	    }
	    scale = ((scale < 0) ? 0 : scale);

	    // create objects
	    first = libbcmath.bc_init_num();
	    second = libbcmath.bc_init_num();
	    result = libbcmath.bc_init_num();

	    first = libbcmath.php_str2num(left_operand.toString());
	    second = libbcmath.php_str2num(right_operand.toString());

	    result = libbcmath.bc_multiply(first, second, scale);

	    if (result.n_scale > scale) {
	        result.n_scale = scale;
	    }
	    return result.toString();
	}

	function bcsub (left_operand, right_operand, scale) {
	    // http://jsphp.co/jsphp/fn/view/bcsub
	    // +   original by: lmeyrick (https://sourceforge.net/projects/bcmath-js/)
	    // -    depends on: _phpjs_shared_bc
	    // *     example 1: bcsub(1, 2);
	    // *     returns 1: -1
	    //  @todo: implement these testcases
	    //        // set scale to zero
	    //        bcscale(0);
	    //
	    //        bcmath.test.result('bcsub', 1, '-1', bcsub('1','2'));
	    //        bcmath.test.result('bcsub', 2, '-6.0000', bcsub('-1','5', 4));
	    //        bcmath.test.result('bcsub', 3, '8728932000054820705086578390258.00', bcsub('8728932001983192837219398127471','1928372132132819737213', 2));
	    //        bcmath.test.result('bcsub', 4, '-1.111000', bcsub('1.123', '2.234', 6));
	    //        bcmath.test.result('bcsub', 5, '-2.20', bcsub('1.123456', '3.333333', 2)); //-2.209877 note: rounding not applicable as bcmath truncates.
	    var libbcmath = this._phpjs_shared_bc();

	    var first, second, result;

	    if (typeof(scale) == 'undefined') {
	        scale = libbcmath.scale;
	    }
	    scale = ((scale < 0) ? 0 : scale);

	    // create objects
	    first = libbcmath.bc_init_num();
	    second = libbcmath.bc_init_num();
	    result = libbcmath.bc_init_num();

	    first = libbcmath.php_str2num(left_operand.toString());
	    second = libbcmath.php_str2num(right_operand.toString());

	    result = libbcmath.bc_sub(first, second, scale);

	    if (result.n_scale > scale) {
	        result.n_scale = scale;
	    }

	    return result.toString();
	}

	function Price($Valor, $Parcelas, $Juros) {

		$Juros = bcdiv($Juros,100,15);
		$E=1.0;
		$cont=1.0;

		for($k=1;$k<=$Parcelas;$k++)
		{
			$cont= bcmul($cont,bcadd($Juros,1,15),15);
			$E=bcadd($E,$cont,15);
		}
		$E=bcsub($E,$cont,15);

		$Valor = bcmul($Valor,$cont,15);
		return bcdiv($Valor,$E,15);
	}

	function PricePrazo($valor, $parcelas, $juros, $intervalo){

		$juros_tratado = (($juros / 30) * $intervalo);

		$aux = Price($valor, $parcelas, $juros_tratado);

		return $aux;
	}

	$(document).ready(function(){

		console.log(Price(10000, 10, 5));
		
	});

</script>

</body>
</html>