$(document).on('submit', 'form#cad-cliente', function(event){
	event.preventDefault();

	var dados_serealize = $('form#cad-cliente').serialize();

	$.ajax({  
		url:'cad_cliente_simulacao.php',  
		method:'GET', 
		data: dados_serealize,
		dataType: 'json',
		success: dados => 	
		{  	
			if(dados){
				$('select#select').append('<option value="'+dados+'"></option>');
				$('select#select').val(dados);

				$('span#status-cli').text("Cliente Cadastrado !");
				$('span#status-cli').css("color", "green");
				$('i.ok').removeClass('hidden');
				$('i.erro').addClass('hidden');

				$("form#cad-cliente button[type='submit']").addClass('hidden');
			}

		},
		error: erro => {console.log(0)}  
	}); 
});

$('form#cad-cliente input#cep').blur(function(){

	var cep = $(this).val();

	$.ajax({  
		url:'consultar_cep.php',  
		method:'POST', 
		data: {cep:cep},
		dataType: 'json',
		success: dados => 	
		{  		 
			if(dados.rua != ' '){
				$('form#cad-cliente input#rua').val(dados.rua);
				$('form#cad-cliente input#cidade').val(dados.cidade);
				$('form#cad-cliente input#estado').val(dados.estado);
				$('form#cad-cliente input#bairro').val(dados.bairro);
			}else{
				$('form#cad-cliente input#rua').val(dados.rua).removeAttr('disabled');
				$('form#cad-cliente input#cidade').val(dados.cidade).removeAttr('disabled');
				$('form#cad-cliente input#estado').val(dados.estado).removeAttr('disabled');
				$('form#cad-cliente input#bairro').val(dados.bairro).removeAttr('disabled');
			}
			
		}
	});
});

$('form#cad-cliente input[name="cpf"]').blur(function(){

	var cpf = $(this).val();

	$.ajax({  
		url:'cad_cliente_simulacao.php',  
		method:'POST', 
		data: {verifica_cpf:cpf},
		dataType: 'json',
		success: dados => 	
		{  	
			if(dados != 0){
				$('form#cad-cliente input#nome').val(dados.nome_cli).attr('disabled', 'true');
				$('form#cad-cliente input#email').val(dados.email_cli).attr('disabled', 'true');

				$('select#select').append('<option value="'+dados.idcliente+'"></option>');
				$('select#select').val(dados.idcliente);

				$('span#status-cli').text("Cliente Cadastrado !");
				$('span#status-cli').css("color", "green");
				$('i.ok').removeClass('hidden');
				$('i.erro').addClass('hidden');

				$("form#cad-cliente button[type='submit']").addClass('hidden');

			}else{
				$('form#cad-cliente input#nome').val('').removeAttr('disabled');
				$('form#cad-cliente input#email').val('').removeAttr('disabled');

				$('select#select').val('-1');

				$('span#status-cli').text("Cliente não Cadastrado !");
				$('span#status-cli').css("color", "red");
				$('i.ok').removeClass('hidden');
				$('i.erro').addClass('hidden');

				$("form#cad-cliente button[type='submit']").removeClass('hidden');
			}
		}
	});
});