<?php
error_reporting(0);
ini_set(“display_errors”, 0);
include "protege_professor.php";
include "conexao.php";

?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8" />
    <title>Immobile | SMS</title>

    <meta content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" name="viewport" />
    <meta content="" name="description" />
    <meta content="" name="author" />

    <!-- ================== BEGIN BASE CSS STYLE ================== -->
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet">
    <link href="https://immobilebusiness.com.br/admin/assets/plugins/jquery-ui/themes/base/minified/jquery-ui.min.css" rel="stylesheet" />
    <link href="https://immobilebusiness.com.br/admin/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://immobilebusiness.com.br/admin/assets/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" />
    <link href="https://immobilebusiness.com.br/admin/assets/css/animate.min.css" rel="stylesheet" />
    <link href="https://immobilebusiness.com.br/admin/assets/css/style.min.css" rel="stylesheet" />
    <link href="https://immobilebusiness.com.br/admin/assets/css/style-responsive.min.css" rel="stylesheet" />
    <link href="https://immobilebusiness.com.br/admin/assets/css/theme/default.css" rel="stylesheet" id="theme" />
    <!-- ================== END BASE CSS STYLE ================== -->

    <!-- ================== BEGIN PAGE LEVEL CSS STYLE ================== -->
    <link href="https://immobilebusiness.com.br/admin/assets/plugins/jquery-jvectormap/jquery-jvectormap-1.2.2.css" rel="stylesheet" />
    <link href="https://immobilebusiness.com.br/admin/assets/plugins/bootstrap-calendar/css/bootstrap_calendar.css" rel="stylesheet" />
    <link href="https://immobilebusiness.com.br/admin/assets/plugins/gritter/css/jquery.gritter.css" rel="stylesheet" />
    <link href="https://immobilebusiness.com.br/admin/assets/plugins/morris/morris.css" rel="stylesheet" />
    <!-- ================== END PAGE LEVEL CSS STYLE ================== -->

    <!-- ================== BEGIN BASE JS ================== -->
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/pace/pace.min.js"></script>
    <!-- ================== END BASE JS ================== -->

</head>

<body>
    <?php

    include_once "topo.php";
    include_once "func_painel.php";
    include_once "func_painel_inadimplencia.php";
    include "conexao.php";

    $query = mysqli_query($db, "SELECT hash FROM usuario_sms WHERE status = '1' ");
    if (mysqli_num_rows($query)) {
        $recebe = mysqli_fetch_assoc($query);
        $hash = $recebe['hash'];
    }

    // Consulta saldo.
    $dado = [];
    $dados = [];
    $dados['acao'] = 'consultar';
    $dados['hash'] = $hash;

    $dado[] = json_encode($dados);

    $ch = curl_init("https://smsmobile.com.br/sms/shortcode/routes/saldo.php");
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $dado);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $saldo_atual = curl_exec($ch);
    $info = curl_getinfo($ch);
    curl_close($ch);
   
    $saldo_atual = json_decode($saldo_atual, true);
    
    if ($saldo_atual['status'] != 'Erro') {
        $saldo_atual = $saldo_atual['saldo'];
    } else {
        $saldo_atual = '0';
    }


    // Consulta total enviado do dia.
    $data_atual = date('Y-m-d', strtotime("-1 day"));

    $dado = [];
    $dados = [];
    $dados['acao'] = 'consultar';
    $dados['hash'] = $hash;
    $dados['data_inicio'] = $data_atual;
    // $dados['data_fim'] = $data_atual;
    $dados['status'] = 'enviado';

    $dado[] = json_encode($dados);

    $ch = curl_init("https://smsmobile.com.br/sms/shortcode/routes/sms.php");
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $dado);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $total_envio = curl_exec($ch);
    $info = curl_getinfo($ch);
    curl_close($ch);

    $total_envio = json_decode($total_envio, true);

    if ($total_envio['status'] != 'Erro') {
        $total_envio = count($total_envio["dados"]);
    } else {
        $total_envio = '0';
    }

    // Consulta para ver se o status esta ativo.
    // $point = curl_init("http://send.smsmobile.com.br/recebe_sms.php?id_msg=$id&numero=$numero&msg=$mensagem");
    // curl_setopt($point, CURLOPT_RETURNTRANSFER, true);
    // $server_output = curl_exec($point);
    // $info_ststus = curl_getinfo($point);
    // curl_close($point);

    $info_ststus["http_code"] = '200';

    if ($info_ststus["http_code"] == '200') {
        $status = 'Online';
    } else {
        $status = 'Offline';
    }


    // Consulta da mensagens aguardado envio.
    $data_atual = date('Y-m-d', strtotime("-1 day"));

    $dado = [];
    $dados = [];
    $dados['acao'] = 'consultar';
    $dados['hash'] = $hash;
    $dados['data_inicio'] = $data_atual;
    $dados['status'] = 'aguardando_envio';

    $dado[] = json_encode($dados);

    $ch = curl_init("https://smsmobile.com.br/sms/shortcode/routes/sms.php");
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $dado);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $aguardando_envio = curl_exec($ch);
    $info = curl_getinfo($ch);
    curl_close($ch);

    $aguardando_envio = json_decode($aguardando_envio, true);

    if ($aguardando_envio['status'] != 'Erro') {
        $aguardando_envio = count($aguardando_envio["dados"]);
    } else {
        $aguardando_envio = '0';
    }

    /// Total de sms enviados
    $dado = [];
    $dados = [];
    $dados['hash']     = $hash;
    $dados['acao']     = 'consultar';
    $dados['status']   = 'enviado';

    $dado[] = json_encode($dados);

    // Estrutura da requisição
    $ch = curl_init("https://smsmobile.com.br/sms/shortcode/routes/sms.php");
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $dado);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $total_enviados = curl_exec($ch);
    $info = curl_getinfo($ch);
    curl_close($ch);

    $total_enviados =  json_decode($total_enviados, true);

    if ($total_enviados['status'] != 'Erro') {
        $total_enviado = count($total_enviados);
    } else {
        $total_enviado = 0;
    }

    // Total de falhas de envio.
    $dado = [];
    $dados = [];
    $dados['hash']     = $hash;
    $dados['acao']     = 'consultar';
    $dados['status']   = 'nao_enviado';

    $dado[] = json_encode($dados);

    // Estrutura da requisição
    $ch = curl_init("https://smsmobile.com.br/sms/shortcode/routes/sms.php");
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $dado);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $total_falhas = curl_exec($ch);
    $info = curl_getinfo($ch);
    curl_close($ch);

    $total_falhas =  json_decode($total_falhas, true);

    if ($total_falhas['status'] != 'Erro') {
        $total_falhas = count($total_falhas);
    } else {
        $total_falhas = 0;
    }


    // Porcentagem.

    if ($total_enviado != 0) {
        $total = $total_enviado + $total_falhas;
        $por_envio = ($total_enviado * 100) / $total;
        $por_falha = ($total_falhas * 100) / $total;
    }else{
        $por_envio = 0;
        $por_falha = 0;
    }

    ?>

    <div id="page-container" class="fade in page-sidebar-fixed page-header-fixed">
        <div id="content" class="content">
            <!-- Titulo -->
            <h1 class="page-header"><strong> SMS | Immobile </strong></h1>

            <!-- Inicio dos quatro Quadrado -->
            <div class="row">
                <!-- begin col-3 -->
                <div class="col-md-3 col-sm-6">
                    <div class="widget widget-stats bg-black">
                        <div class="stats-icon stats-icon-lg"><i class="fa fa-dollar fa-fw"></i></div>
                        <div class="stats-title">SALDO ATUAL (SMS)</div>
                        <div class="stats-number"><?php echo $saldo_atual ?> </div>
                    </div>
                </div>
                <!-- end col-3 -->
                <!-- begin col-3 -->
                <div class="col-md-3 col-sm-6">
                    <div class="widget widget-stats bg-blue">
                        <div class="stats-icon stats-icon-lg"><i class="fa fa-envelope-o fa-fw"></i></div>
                        <div class="stats-title">TOTAL ENVIO DIA (SMS)</div>
                        <div class="stats-number"> <?php echo $total_envio ?> </div>
                    </div>
                </div>
                <!-- end col-3 -->
                <!-- begin col-3 -->
                <div class="col-md-3 col-sm-6">
                    <div class="widget widget-stats bg-purple">
                        <div class="stats-icon stats-icon-lg"><i class="fa fa-envelope-o fa-fw"></i></div>
                        <div class="stats-title">AGUARDANDO ENVIO (SMS)</div>
                        <div class="stats-number"> <?php echo $aguardando_envio ?> </div>
                    </div>
                </div>
                <!-- end col-3 -->
                <!-- begin col-3 -->
                <div class="col-md-3 col-sm-6">
                    <div class="widget widget-stats <?php if ($info_ststus["http_code"] == '200') { ?> bg-green <?php } else { ?> bg-red <?php } ?>">
                        <div class="stats-icon stats-icon-lg"><i class="fa fa-cogs fa-fw"></i></div>
                        <div class="stats-title">STATUS DO SERVIÇO (SMS)</div>
                        <div class="stats-number"><?php echo $status ?></div>
                    </div>
                </div>
                <!-- end col-3 -->
            </div>

            <!-- Inicio do Grafico e Componentes do envio -->
            <div class="row">
                <!-- Grafico -->
                <div class="col-md-12">
                    <div class="widget-chart with-sidebar bg-black">
                        <div class="widget-chart-content">
                            <h4 class="chart-title">
                                Controle de SMS
                                <small>Grafico Real Do Consumo</small>
                            </h4>
                            <div id="visitors-line-chart" class="morris-inverse" style="height: 260px;"></div>
                        </div>
                        <div class="widget-chart-sidebar bg-black-darker">
                            <div class="chart-number">
                                <small>Total de SMS Enviados </small>
                                <?php echo $total_enviado ?>
                            </div>
                            <div id="visitors-donut-chart" style="height: 160px"></div>
                            <ul class="chart-legend">
                                <li><i class="fa fa-circle-o fa-fw text-primary m-r-5"></i> <?php echo round($por_envio, 2) . "%" ?> <span> Enviados</span>
                                </li>
                                <li><i class="fa fa-circle-o fa-fw text-success m-r-5"></i> <?php echo round($por_falha, 2) . "%" ?> <span> Falha no Envio</span></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ================== BEGIN BASE JS ================== -->
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/jquery/jquery-1.9.1.min.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/jquery/jquery-migrate-1.1.0.min.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/jquery-ui/ui/minified/jquery-ui.min.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/slimscroll/jquery.slimscroll.min.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/jquery-cookie/jquery.cookie.js"></script>
    <!-- ================== END BASE JS ================== -->

    <!-- ================== BEGIN PAGE LEVEL JS ================== -->
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/morris/raphael.min.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/morris/morris.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/plugins/gritter/js/jquery.gritter.js"></script>
    <script src="https://immobilebusiness.com.br/admin/assets/js/apps.min.js"></script>
    <!-- <script src="https://immobilebusiness.com.br/admin/assets/js/dashboard-v2.min.js"></script> -->
    <!-- ================== END PAGE LEVEL JS ================== -->

    <?php $ano = date('Y'); ?>
    <script>
        $(document).ready(function() {
            App.init();
            DashboardV2.init();
        });
    </script>



    <?php

    include "conexao.php";

    $ano = date('Y');

    $recebe = mysqli_query($db, "SELECT hash FROM usuario_sms WHERE status = '1'");
    if (mysqli_num_rows($recebe)) {
        $recebe = mysqli_fetch_assoc($recebe);
        $hash = $recebe['hash'];
    }

    $recebe_qtq = [];

    $data_inicio = "01-01-" . $ano;
    $data_fim = "29-01-" . $ano;

    for ($i = 0; $i <= 11; $i++) {

        $dado = [];
        $dados = [];
        $dados['hash']              = $hash;
        $dados['acao']              = 'consultar';
        $dados['data_inicio']       = $data_inicio;
        $dados['data_fim']          = $data_fim;
        $dados['status']            = 'enviado';

        $dado[] = json_encode($dados);


        // Estrutura da requisição
        $ch = curl_init("https://smsmobile.com.br/sms/shortcode/routes/sms.php");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $dado);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $server_output = curl_exec($ch);
        $info = curl_getinfo($ch);
        curl_close($ch);

        $dados =  json_decode($server_output, true);

        if ($dados['status'] != 'Erro') {
            $recebe_qtq[] = count($dados);
        } else {
            $recebe_qtq[] = 0;
        }

        $data_inicio = strtotime($data_inicio); // your date
        $data_fim = strtotime($data_fim); // your date

        $data_inicio = $date = date('d-m-Y', strtotime("+1 month", $data_inicio));
        $data_fim = date('d-m-Y', strtotime("+1 month", $data_fim));
    }


    ?>
    <script>
        const ano_atual = '<?php echo date('Y'); ?>';
        var janeiro = '<?php echo $recebe_qtq[0]; ?>';
        var fevereiro = '<?php echo $recebe_qtq[1]; ?>';
        var marco = '<?php echo $recebe_qtq[2]; ?>';
        var abril = '<?php echo $recebe_qtq[3]; ?>';
        var maio = '<?php echo $recebe_qtq[4]; ?>';
        var junho = '<?php echo $recebe_qtq[5]; ?>';
        var julho = '<?php echo $recebe_qtq[6]; ?>';
        var agosto = '<?php echo $recebe_qtq[7]; ?>';
        var setembro = '<?php echo $recebe_qtq[8]; ?>';
        var outubro = '<?php echo $recebe_qtq[9]; ?>';
        var novembro = '<?php echo $recebe_qtq[10]; ?>';
        var dezembro = '<?php echo $recebe_qtq[11]; ?>';

        var total_enviados = '<?php echo $total_enviado ?>';
        var total_falhas = '<?php echo $total_falhas ?>';


        var getMonthName = function(a) {
                var b = [];
                return b[0] = "Jan", b[1] = "Fev", b[2] = "Mar", b[3] = "Abr", b[4] = "Mai", b[5] = "Jun", b[
                        6] = "Jul", b[7] = "Ago", b[8] = "Set", b[9] = "Out", b[10] = "Nov", b[11] =
                    "Dez", b[a]
            },
            getDate = function(a) {
                var b = new Date(a),
                    c = b.getDate(),
                    d = b.getMonth() + 1,
                    e = b.getFullYear();
                return c < 10 && (c = "0" + c), d < 10 && (d = "0" + d), b = e + "-" + d + "-" + c
            },
            handleVisitorsLineChart = function() {
                var a = "#0D888B",
                    b = "#00ACAC",
                    c = "#3273B1",
                    d = "#348FE2",
                    e = "rgba(0,0,0,0.6)",
                    f = "rgba(255,255,255,0.4)";
                Morris.Line({
                    element: "visitors-line-chart",
                    data: [{
                        x: ano_atual + "-01-01",
                        y: janeiro,
                    }, {
                        x: ano_atual + "-02-01",
                        y: fevereiro,
                    }, {
                        x: ano_atual + "-03-01",
                        y: marco,
                    }, {
                        x: ano_atual + "-04-01",
                        y: abril,
                    }, {
                        x: ano_atual + "-05-01",
                        y: maio,
                    }, {
                        x: ano_atual + "-06-01",
                        y: junho,
                    }, {
                        x: ano_atual + "-07-01",
                        y: julho,
                    }, {
                        x: ano_atual + "-08-01",
                        y: agosto,
                    }, {
                        x: ano_atual + "-09-01",
                        y: setembro,
                    }, {
                        x: ano_atual + "-10-01",
                        y: outubro,
                    }, {
                        x: ano_atual + "-11-01",
                        y: novembro,
                    }, {
                        x: ano_atual + "-12-01",
                        y: dezembro,
                    }],
                    xkey: "x",
                    ykeys: ["y"],
                    xLabelFormat: function(a) {
                        return a = getMonthName(a.getMonth()), a.toString()
                    },
                    labels: ["Page Views", "Unique Visitors"],
                    lineColors: [a, c],
                    pointFillColors: [b, d],
                    lineWidth: "3px",
                    pointStrokeColors: [e, e],
                    resize: !0,
                    gridTextFamily: "Open Sans",
                    gridTextColor: f,
                    gridTextWeight: "normal",
                    gridTextSize: "11px",
                    gridLineColor: "rgba(0,0,0,0.5)",
                    hideHover: "auto"
                })
            },
            handleVisitorsDonutChart = function() {
                var a = "#348fe2",
                    b = "#00acac";
                Morris.Donut({
                    element: "visitors-donut-chart",
                    data: [{
                        label: "Enviados",
                        value: total_enviados
                    }, {
                        label: "Falhas",
                        value: total_falhas
                    }],
                    colors: [a, b],
                    labelFamily: "Open Sans",
                    labelColor: "rgba(255,255,255,0.4)",
                    labelTextSize: "12px",
                    backgroundColor: "#242a30"
                })
            }
        DashboardV2 = function() {
            "use strict";
            return {
                init: function() {
                    handleVisitorsLineChart(), handleVisitorsDonutChart()
                }
            }
        }();
    </script>

</body>

</html>