<?php

function consulta_empreendimento($empreendimento, $db)
{

    $query = mysqli_query($db, "SELECT `empreendimento_cadastro_id` FROM `empreendimento` WHERE `idempreendimento` = $empreendimento") or die(mysqli_error($db));

    $executa_query = mysqli_fetch_assoc($query);

    if (!empty($executa_query)) {
        return $executa_query['empreendimento_cadastro_id'];
    } else {
        return false;
    }
}

function consulta_venda($lote, $quadra, $db)
{

    $aux = mysqli_query($db, "SELECT idvenda FROM `venda` 
		INNER JOIN produto ON produto.idproduto = venda.produto_idproduto
		INNER JOIN lote ON lote.idlote = venda.lote_idlote
		WHERE produto.idproduto = $quadra AND lote.idlote = $lote") or die(mysqli_error($db));

    $executa_query = mysqli_fetch_assoc($aux);
    if (!empty($executa_query)) {
        return $executa_query['idvenda'];
    } else {
        return false;
    }
}

function consulta_cliente_venda($lote, $quadra, $db)
{

    $aux = mysqli_query($db, "SELECT cliente_idcliente FROM `venda` 
		INNER JOIN produto ON produto.idproduto = venda.produto_idproduto
		INNER JOIN lote ON lote.idlote = venda.lote_idlote
		WHERE produto.idproduto = $quadra AND lote.idlote = $lote") or die(mysqli_error($db));

    $executa_query = mysqli_fetch_assoc($aux);
    if (!empty($executa_query)) {
        return $executa_query['cliente_idcliente'];
    } else {
        return false;
    }
}

function consulta_imobiliaria($imobliaria, $db)
{

    $query = mysqli_query($db, "SELECT idcliente FROM `cliente` WHERE `nome_cli`= '$imobliaria' ");

    $executa_query = mysqli_fetch_assoc($query);

    if (!empty($executa_query)) {
        return $executa_query['idcliente'];
    } else {
        return false;
    }
}

function consulta_quadra($empreendimento, $quadra, $db)
{

    $query = mysqli_query($db, "SELECT produto.idproduto FROM produto
		INNER JOIN empreendimento ON empreendimento.idempreendimento = produto.empreendimento_idempreendimento
		WHERE produto.quadra ='$quadra' AND empreendimento.idempreendimento = '$empreendimento'  ");

    if ($query != null) {
        $executa_query = mysqli_fetch_assoc($query);

        if (!empty($executa_query)) {
            return $executa_query['idproduto'];
        }
    } else {
        return false;
    }
}

function consulta_lote($empreendimento, $quadra, $lote, $db)
{

    $query = mysqli_query($db, "SELECT lote.idlote FROM lote INNER JOIN produto 
		ON produto.idproduto = lote.produto_idproduto INNER JOIN empreendimento 
		ON empreendimento.idempreendimento = produto.empreendimento_idempreendimento 
		WHERE lote.lote = '$lote' AND produto.idproduto = $quadra AND empreendimento.idempreendimento = $empreendimento ") or die(mysqli_error($db));

    $query ? $executa_query = mysqli_fetch_assoc($query) : $executa_query = '';

    if (!empty($executa_query)) {
        return $executa_query['idlote'];
    } else {
        return false;
    }
}

function consulta_cliente($cliente, $db)
{

    $query = mysqli_query($db, "SELECT idcliente FROM `cliente` WHERE `nome_cli`= '$cliente' ");
    $executa_query = mysqli_fetch_assoc($query);


    if (!empty($executa_query)) {
        return $executa_query['idcliente'];
    } else {
        return false;
    }
}

function formata_data($data)
{
    $aux = str_replace('/', '-', $data);

    // $aux1 = $aux[1];
    // $aux[1] = $aux[0];
    // $aux[0] = $aux1;

    // if($aux[2] > 90){
    //     $aux[2] = "19".$aux[2];
    // }else{
    //     $aux[2] = "20".$aux[2];
    // }

    return $aux;
}

function formata_valor($valor)
{
    $aux = explode(" ", $valor);

    /*
    $aux = explode(".", $aux[1]);

    //OBS: vard_dump na $linha para ver como vem a informação
    //$aux = str_replace('.', '', $aux[0]);
    //$aux = str_replace(',', '', $aux[1]);

    $aux = number_format($aux[0], 2, '.', '');
    */

    return $aux[1];
}

function formata_quadra_lote($quadra)
{

    //var_dump(strpos($quadra, '0'));
    //die();

    $valida = 1;
    //var_dump($quadra);

    for ($i = 0; $i < strlen($quadra); $i++) {

        //var_dump($quadra[$i]);
        //echo "</br></br>";

        if (!is_numeric($quadra[$i])) {
            $valida = 0;
            break;
        }
    }


    if (strpos($quadra, '0') === 0 && $valida == 1) {
        $quadra = str_replace('0', '', $quadra);
    }


    /* assim esta colocando o 0 na frente
    if(($quadra > 0 && $quadra < 10) && strpos($quadra, '0') !== 0){
        $aux = $quadra;

        $quadra = '0'.$aux;
    }*/

    return $quadra;
}

function formata_percentual($taxa)
{
    $aux = str_replace('%', '', $taxa);
    $aux = str_replace(',', '.', $aux);

    return $aux;
}

function grava_planilha_venda($arquivo, $empreendimento)
{ // Passando o caminho do arquivo

    include_once "conexao.php";
    $retorno["ok"] = array();

    // If you need to parse XLS files, include_once php-excel-reader
    require('spreadsheet-reader-master/PHPExcel.php');
    require('spreadsheet-reader-master/php-excel-reader/excel_reader2.php');
    require('spreadsheet-reader-master/SpreadsheetReader.php');


    $tabela_erro = new PHPExcel();
    $colunas = ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X"];

    $Reader = new SpreadsheetReader($arquivo); // Crio o objeto do arquivo
    $Sheets = $Reader->Sheets(); // Obtenho as planilhas do arquivo

    foreach ($Sheets as $Index => $Name) { // Para percorrer as planilhas do arquivo
        $aux_erro = 2;
        $Reader->ChangeSheet($Index);  // Habilito a página atual para edição

        foreach ($Reader as $registro => $linha) {  //Para percorrer as linhas dentro da planilha

            $cont = 0;

            //Verifico se a linha está completamente vazia 
            foreach ($linha as $valor) {
                if (empty($valor)) {
                    $cont++;
                }
            }

            //Se a linha estiver vazia o script para a varredura
            if ($cont == 21 && $registro > 6) {
                break;
            }

            //Esse bloco verifica o titulo da planilha
            if ($registro == 0) {
                $aux = 0;
                foreach ($linha as $valor) {
                    if ($valor == "TABELA PARA CADASTRO DE CONTRATOS") {
                        $aux = 1;
                    }
                }
                if ($aux !== 1) {
                    break;
                }
            }

            if ($registro == 6) {
                for ($i = 0; $i <= count($linha); $i++) {
                    if ($i == count($linha)) {
                        $tabela_erro->setActiveSheetIndex(0)->setCellValue("" . $colunas[$i] . "1", "Problema(s)");
                        break;
                    }
                    $tabela_erro->setActiveSheetIndex(0)->setCellValue("" . $colunas[$i] . "1", $linha[$i]);
                }
            }

            // Verifico se já passou as linhas de informação no começo do arquivo
            if ($registro > 6) {
                $problema = '';
                $venda;
                $aux;
                $valida = 1;

                for ($i = 0; $i < count($linha); $i++) {

                    // Imobiliaria/ corretor
                    if ($i == 0) {
                        if (!empty($linha[$i])) {
                            if (consulta_imobiliaria($linha[$i], $db)) {
                                $venda['imobiliaria'] = consulta_imobiliaria($linha[$i], $db);
                            } else {
                                $problema .= "Imobiliaria ou Corretor Não encontrados";
                                $valida = 0;
                                break;
                            }
                        } else {
                            $problema .= "Imobiliaria ou Corretor não preenchido";
                            $valida = 0;
                            break;
                        }
                    }

                    // Validação de quadra
                    elseif ($i == 1) {
                        if (empty($linha[$i])) {
                            $valida = 0;
                            $problema = "Quadra nao preenchido";
                            break;
                        } else {

                            $aux = formata_quadra_lote($linha[$i]);

                            if (consulta_quadra($empreendimento, $aux, $db)) {
                                $venda['quadra'] = consulta_quadra($empreendimento, $aux, $db);
                            } else {
                                $problema = "Quadra não encontrada";
                                $valida = 0;
                                break;
                            }
                        }
                    }

                    // Validação de lote
                    elseif ($i == 2) {
                        if (empty($linha[$i])) {
                            $valida = 0;
                            $problema = "Lote nao preenchido";
                            break;
                        } else {

                            $aux2 = $linha[$i];
                            if (consulta_lote($empreendimento, $venda['quadra'], $aux2, $db)) {
                                $venda['lote'] = consulta_lote($empreendimento, $venda['quadra'], $aux2, $db);
                            } else {
                                $query = mysqli_query($db, "INSERT INTO `lote`(`lote`, `m2`, `valor`, `produto_idproduto`, `status`, `frente`, `fundo`, `direita`, `esquerda`, `esquina`, `endereco`, `matricula`, `cadastro_prefeitura`, `confrontacao`, `cx`, `cy`, `mld`, `mle`, `mfrente`, `mfundo`, `coutros`, `moutros`, obs_lote, motivo_bloqueio) 
									VALUES ('" . $aux[1] . "','0', '0' ,'" . $venda['quadra'] . "','2','0','0','0','0','','','','','','','','','','','','','', 'Lote cadastrado a partir das parcelas','')") or die(mysqli_error($db));

                                $venda['lote'] = mysqli_insert_id($db);
                            }
                        }
                    }

                    // Validação do valor do lote
                    elseif ($i == 3) {
                        if (empty($linha[$i])) {
                            $problema .= "Valor do lote Não digitado";
                            $valida = 0;
                            break;
                        } else {
                            $venda['valor_lote'] = formata_valor($linha[$i]);
                        }
                    }

                    // Validação do Nome
                    elseif ($i == 4) {
                        if (empty($linha[$i])) {
                            $problema .= "Cliente Não digitado";
                            $valida = 0;
                            break;
                        } else {

                            if (consulta_cliente($linha[$i], $db)) {
                                $venda['cliente'] = consulta_cliente($linha[$i], $db);
                            } else {
                                $problema .= "Cliente Não encontrado";
                                $valida = 0;
                                break;
                            }
                        }
                    }

                    //data  da venda
                    elseif ($i == 5) {
                        if (!empty($linha[$i])) {
                            $venda['data_venda'] = formata_data($linha[$i]);
                        } else {
                            $problema .= "Data não digitada";
                            $valida = 0;
                            break;
                        }
                    }

                    // Status da Venda
                    elseif ($i == 6) {

                        if (!empty($linha[$i]) && $linha[$i] >= 0 && $linha[$i] <= 4) {
                            $venda['status'] = $linha[$i];
                        } else {
                            $problema .= "Status invalido";
                            $valida = 0;
                            break;
                        }
                    }

                    // Numero da ficha
                    elseif ($i == 7) {
                        if (!empty($linha[$i])) {
                            $venda['numero_ficha'] = $linha[$i];
                        } else {
                            $problema .= "Numero da ficha não digitado";
                            $valida = 0;
                            break;
                        }
                    }

                    // Desconto da venda
                    elseif ($i == 8) {
                        if (!empty($linha[$i])) {
                            $venda['desconto'] = formata_valor($linha[$i]);
                        } else {
                            $venda['desconto'] = '';
                        }
                    }

                    // Entrada / Sinal
                    elseif ($i == 9) {
                        if (!empty($linha[$i])) {
                            $venda['entrada_sinal'] = formata_valor($linha[$i]);
                        } else {
                            $venda['entrada_sinal'] = '';
                        }
                    }

                    // Entrada da venda
                    elseif ($i == 10) {
                        if (!empty($linha[$i])) {
                            $venda['entrada'] = formata_valor($linha[$i]);
                        } else {
                            $venda['entrada'] = '';
                        }
                    }

                    // Parcelameto da Entrada
                    elseif ($i == 11) {
                        if (!empty($linha[$i])) {
                            $venda['parce_entrada'] = $linha[$i];
                        } else {
                            $venda['parce_entrada'] = '';
                        }
                    }

                    // Vencimento da primeira parcela
                    elseif ($i == 12) {
                        if (!empty($linha[$i])) {
                            $venda['vencimento_primeira'] =  formata_data($linha[$i]);
                        } else {
                            $venda['vencimento_primeira'] = '';
                        }
                    }

                    //Vencimento das parcelas restantes
                    elseif ($i == 13) {
                        if (!empty($linha[$i])) {
                            $venda['vencimento_restante'] =  formata_data($linha[$i]);
                        } else {
                            $venda['vencimento_restante'] = '';
                        }
                    }

                    //Periodo das parcelas intermediarias
                    elseif ($i == 14) {
                        if (!empty($linha[$i])) {
                            $venda['periodo'] = $linha[$i];
                        } else {
                            $venda['periodo'] = '';
                        }
                    }

                    // Quantidades das parcelas Intermediarias
                    elseif ($i == 15) {
                        if (!empty($linha[$i])) {
                            $venda['qtd_parcelas'] = $linha[$i];
                        } else {
                            $venda['qtd_parcelas'] = '';
                        }
                    }

                    // Valor das parcelas
                    elseif ($i == 16) {
                        if (!empty($linha[$i])) {
                            $venda['valor_parcela'] = formata_valor($linha[$i]);
                        } else {
                            $venda['valor_parcela'] = '';
                        }
                    }

                    // Data da primeira parcela intermediaria
                    elseif ($i == 17) {
                        if (!empty($linha[$i])) {
                            $venda['data_primeira_parcela'] = formata_data($linha[$i]);
                        } else {
                            $venda['data_primeira_parcela'] = '';
                        }
                    }

                    // Valor para Financiamento
                    elseif ($i == 18) {
                        if (!empty($linha[$i])) {
                            $venda['valor_financiamento'] = formata_valor($linha[$i]);
                        } else {
                            $venda['valor_financiamento'] = '';
                        }
                    }

                    // Valor das parcelas do financiamento
                    elseif ($i == 19) {
                        if (!empty($linha[$i])) {
                            $venda['valor_parcela_fin'] = formata_valor($linha[$i]);
                        } else {
                            $venda['valor_parcela_fin'] = '';
                        }
                    }

                    // Plano de pagamento do financiamento
                    elseif ($i == 20) {
                        if (!empty($linha[$i])) {
                            $venda['plano_pagamento'] = $linha[$i];
                        } else {
                            $venda['plano_pagamento'] = '';
                        }
                    }

                    // Taxa do Financiamento
                    elseif ($i == 21) {
                        if (!empty($linha[$i])) {
                            $venda['taxa'] = $linha[$i];
                        } else {
                            $venda['taxa'] = '';
                        }
                    }
                }

                if ($valida == 1) {

                    if (isset($venda['valor_lote'])) {
                        $query = mysqli_query($db, "UPDATE `lote` SET `valor`= '" . $venda['valor_lote'] . "', `status` = 2 WHERE `idlote`= " . $venda['lote'] . "");
                    }

                    $id_endereco = mysqli_query($db, "SELECT idendereco FROM endereco_cli WHERE id_cliente = '".$venda['cliente']."'") or die(mysqli_error($db));

                    if(mysqli_num_rows($id_endereco)){
                        while ($recebe = mysqli_fetch_assoc($id_endereco)) {
                             $id_endereco = $recebe['idendereco'];
                         } 
                    }

                    $aux = mysqli_query($db, "INSERT INTO venda(imobiliaria_idimobiliaria, produto_idproduto, cliente_idcliente, numero_ficha, desconto, valor_entrada, entrada_restante, vencimento_primeira, plano_pagamento, taxa_financiamento, data_venda, parcela_entrada, lote_idlote, vencimento_restante, status_venda, valor_parcela_financiamento, valor_parcela_entrada, inter_periodo, inter_qtd, inter_valor, inter_data, endereco_idendereco)  VALUES('" . $venda['imobiliaria'] . "', '" . $venda['quadra'] . "', '" . $venda['cliente'] . "', '" . $venda['numero_ficha'] . "', '" . $venda['desconto'] . "', '" . $venda['entrada_sinal'] . "', '".$venda['entrada']."', '" . $venda['vencimento_primeira'] . "', '" . $venda['plano_pagamento'] . "', '" . $venda['taxa'] . "', '" . $venda['data_venda'] . "', '" . $venda['parce_entrada'] . "', '" . $venda['lote'] . "', '" . $venda['vencimento_restante'] . "', '" . $venda['status'] . "', '" . $venda['valor_financiamento'] . "', '".$venda['valor_parcela_fin']."' , '" . $venda['periodo'] . "', '" . $venda['qtd_parcelas'] . "', '" . $venda['valor_parcela'] . "', '" . $venda['data_primeira_parcela'] . "', $id_endereco)") or die(mysqli_error($db));

                    //Rotina para pegar o ID do último elemento inserido na tabela venda, e insere na tabela propietario_lote.
                    //$id_venda = mysqli_fetch_assoc(mysqli_query($db, "SELECT idvenda FROM venda ORDER BY idvenda DESC LIMIT 1")or die(mysqli_error($db)));

                    $id_venda = mysqli_insert_id($db);
                    /*
                    if(mysqli_query($db, "SELECT idvenda FROM venda ORDER BY idvenda DESC LIMIT 1")){
                        $id_venda = mysqli_fetch_assoc(mysqli_query($db, "SELECT idvenda FROM venda ORDER BY idvenda DESC LIMIT 1"));
                        $id_venda = $id_venda['idvenda'];
                    }else{
                        echo "id nao encontrado";
                        die();
                    }*/
                    $cod_cessao = date('YmdHis') . $registro;

                    $aux = mysqli_query($db, "INSERT INTO `proprietarios_lote`(`venda_id`, `cliente_id`, `percentual`, `cod_cessao`, `situacao_cessao`) VALUES ('$id_venda','" . $venda['cliente'] . "','100','$cod_cessao','1')") or die(mysqli_error($db));
                    array_push($retorno['ok'], $registro);
                } else {

                    // Insere as linha incorretas na tabela de erros
                    for ($i = 0; $i <= count($linha); $i++) {
                        if ($i == count($linha)) {
                            $tabela_erro->setActiveSheetIndex(0)->setCellValue("" . $colunas[$i] . $aux_erro . "", $problema);
                            break;
                        }
                        $tabela_erro->setActiveSheetIndex(0)->setCellValue("" . $colunas[$i] . $aux_erro . "", $linha[$i]);
                    }
                    $aux_erro++;

                    $retorno["error"] = 1;
                }
            }
        }


        $file = $objWriter = PHPExcel_IOFactory::createWriter($tabela_erro, 'Excel2007');
        $file->save("planilhas/falhas.xlsx");

        return $retorno;
    }
}

// function grava_planilha_venda_encerrada($arquivo, $empreendimento)
// { // Passando o caminho do arquivo

//     include_once "conexao.php";

//     $retorno["ok"] = array();

//     // If you need to parse XLS files, include_once php-excel-reader
//     require('spreadsheet-reader-master/PHPExcel.php');
//     require('spreadsheet-reader-master/php-excel-reader/excel_reader2.php');
//     require('spreadsheet-reader-master/SpreadsheetReader.php');


//     $tabela_erro = new PHPExcel();
//     $colunas = ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X"];

//     $Reader = new SpreadsheetReader($arquivo); // Crio o objeto do arquivo
//     $Sheets = $Reader->Sheets(); // Obtenho as planilhas do arquivo

//     foreach ($Sheets as $Index => $Name) { // Para percorrer as planilhas do arquivo
//         $aux_erro = 2;
//         $Reader->ChangeSheet($Index);  // Habilito a página atual para edição

//         foreach ($Reader as $registro => $linha) {  //Para percorrer as linhas dentro da planilha

//             $cont = 0;

//             //Verifico se a linha está completamente vazia 
//             foreach ($linha as $valor) {
//                 if (empty($valor)) {
//                     $cont++;
//                 }
//             }

//             //Se a linha estiver vazia o script para a varredura
//             if ($cont == 15 && $registro > 2) {
//                 break;
//             }

//             //Esse bloco verifica o titulo da planilha
//             if ($registro == 0) {
//                 $aux = 0;
//                 foreach ($linha as $valor) {
//                     if ($valor == "TABELA PARA CADASTRO DE CONTRATOS") {
//                         $aux = 1;
//                     }
//                 }
//                 if ($aux !== 1) {
//                     break;
//                 }
//             }
//             if ($registro == 2) {
//                 for ($i = 0; $i <= count($linha); $i++) {
//                     if ($i == count($linha)) {
//                         $tabela_erro->setActiveSheetIndex(0)->setCellValue("" . $colunas[$i] . "1", "Problema(s)");
//                         break;
//                     }
//                     $tabela_erro->setActiveSheetIndex(0)->setCellValue("" . $colunas[$i] . "1", $linha[$i]);
//                 }
//             }


//             // Verifico se já passou as linhas de informação no começo do arquivo
//             if ($registro > 2) {

//                 // Validação dos dados da linha atual, segue abaixo os Index de cada coluna dentro da $linha

//                 // imobiliaria = 0           Entrada/Sinal = 7               
//                 // Quadra = 1                Entrada = 8                     
//                 // Lote = 2                  Parcelamento Entrada = 9        
//                 // Cliente = 3               Vencimento 1 = 10               
//                 // Data da Venda = 4         Vencimento Restante = 11        
//                 // Número da Ficha = 5       Periodo = 12                 
//                 // Desconto = 6              Qntd Parcelas = 13


//                 //var_dump($linha);
//                 //die();
//                 $problema = '';
//                 $venda;
//                 $aux;
//                 $valida = 1;
//                 for ($i = 0; $i < count($linha); $i++) {

//                     // Validação lote e quadra
//                     if ($i == 0) {
//                         if (empty($linha[$i])) {
//                             $valida = 0;
//                             $problema = "Lote ou quadra nao preenchido";
//                             break;
//                         } else {
//                             $aux = ($linha[$i]);
//                             $aux = explode('*', $aux);
//                             $aux[0] = formata_quadra_lote($aux[0]);
//                             $aux[1] = formata_quadra_lote($aux[1]);

//                             /*
//                             var_dump($empreendimento);
//                             var_dump(consulta_quadra($empreendimento, $aux[0]));
//                             echo "</br>";
//                             var_dump(consulta_lote($empreendimento, consulta_quadra($empreendimento, $aux[0]), $aux[1]));
//                             echo "</br>";
//                             var_dump($aux);
//                             die();
//                             */

//                             if (consulta_quadra($empreendimento, $aux[0], $db)) {
//                                 $venda['quadra'] = consulta_quadra($empreendimento, $aux[0], $db);

//                                 if (consulta_lote($empreendimento, $venda['quadra'], $aux[1], $db)) {
//                                     $venda['lote'] = consulta_lote($empreendimento, $venda['quadra'], $aux[1], $db);
//                                 } else {
//                                     $query = mysqli_query($db, "INSERT INTO `lote`(`lote`, `m2`, `valor`, `produto_idproduto`, `status`, `frente`, `fundo`, `direita`, `esquerda`, `esquina`, `endereco`, `matricula`, `cadastro_prefeitura`, `confrontacao`, `cx`, `cy`, `mld`, `mle`, `mfrente`, `mfundo`, `coutros`, `moutros`, obs_lote, motivo_bloqueio) 
//                                         VALUES ('" . $aux[1] . "','0', '0' ,'" . $venda['quadra'] . "','3','0','0','0','0','','','','','','','','','','','','','', 'Lote cadastrado a partir das parcelas','')") or die(mysqli_error($db));


//                                     $venda['lote'] = mysqli_insert_id($db);
//                                 }
//                             } else {
//                                 $problema = "Quadra Não encontrado";
//                                 $valida = 0;
//                                 break;
//                             }
//                         }
//                     }

//                     // Validação do Nome
//                     elseif ($i == 1) {
//                         if (empty($linha[$i])) {
//                             $problema .= "Cliente Não digitado";
//                             $valida = 0;
//                             break;
//                         } else {
//                             if (consulta_cliente($linha[$i], $db)) {
//                                 $venda['cliente'] = consulta_cliente($linha[$i], $db);
//                             } else {
//                                 $problema .= "Cliente Não encontrado";
//                                 $valida = 0;
//                                 break;
//                             }
//                         }
//                     } elseif ($i == 2) {
//                         if (!empty($linha[$i])) {
//                             $venda['data_venda'] = formata_data($linha[$i]);
//                         } else {
//                             $venda['data_venda'] = '';
//                         }
//                     } elseif ($i == 3) {
//                         if (!empty($linha[$i])) {
//                             $venda['vencimento_primeira'] = formata_data($linha[$i]);
//                         } else {
//                             $venda['vencimento_primeira'] = '';
//                         }
//                     } elseif ($i == 4) {
//                         if (!empty($linha[$i])) {
//                             $venda['primeira_inter'] = formata_data($linha[$i]);
//                         } else {
//                             $venda['primeira_inter'] = '';
//                         }
//                     } elseif ($i == 5) {
//                         if (!empty($linha[$i])) {
//                             $venda['num_parcela'] = ($linha[$i]);
//                         } else {
//                             $venda['num_parcela'] = '';
//                         }
//                     } elseif ($i == 6) {
//                         if (!empty($linha[$i])) {
//                             $venda['num_inter'] = ($linha[$i]);
//                         } else {
//                             $venda['num_inter'] = '';
//                         }
//                     } elseif ($i == 7) {
//                         if (!empty($linha[$i])) {
//                             $venda['valor_entrada'] = formata_valor($linha[$i]);
//                         } else {
//                             $venda['valor_entrada'] = '';
//                         }
//                     } elseif ($i == 8) {
//                         if (!empty($linha[$i])) {
//                             $venda['valor_primeira_parcela'] = formata_valor($linha[$i]);
//                         } else {
//                             $venda['valor_primeira_parcela'] = '';
//                         }
//                     } elseif ($i == 9) {
//                         if (!empty($linha[$i])) {
//                             $venda['valor_parcela'] = formata_valor($linha[$i]);
//                         } else {
//                             $venda['valor_parcela'] = '';
//                         }
//                     } elseif ($i == 10) {
//                         if (!empty($linha[$i])) {
//                             $venda['valor_inter'] = formata_valor($linha[$i]);
//                         } else {
//                             $venda['valor_inter'] = '';
//                         }
//                     } elseif ($i == 11) {
//                         if (!empty($linha[$i])) {
//                             $venda['valor_lote'] = formata_valor($linha[$i]);
//                         } else {
//                             $venda['valor_lote'] = '';
//                         }
//                     }

//                     // armazenamento Periodo Inter
//                     elseif ($i == 12) {
//                         if (!empty($linha[$i])) {
//                             consulta_imobiliaria($linha[$i], $db) ? $venda['vendedor'] = consulta_imobiliaria($linha[$i], $db) : $venda['vendedor'] = '1665';
//                         } else {
//                             $problema = "vendedor nao encontrado";
//                             $valida = 0;
//                             break;
//                         }
//                     }

//                     // armazenamento Qntd parcelas Inter
//                     elseif ($i == 13) {
//                         if (!empty($linha[$i])) {
//                             $venda['cad_spc'] = $linha[$i];
//                         } else {
//                             $venda['cad_spc'] = '';
//                         }
//                     }
//                 }

//                 //var_dump($linha);

//                 if ($valida == 1) {

//                     if (isset($venda['valor_lote'])) {
//                         //$query = mysqli_query($db, "UPDATE `lote` SET `valor`= '".$venda['valor_lote']."' WHERE `idlote`= ".$venda['lote']."");
//                     }

//                     $aux = mysqli_query($db, "INSERT INTO `venda`(`imobiliaria_idimobiliaria`, `produto_idproduto`, `cliente_idcliente`, `numero_ficha`, `desconto`, `valor_desconto`, `valor_entrada`, `vencimento_primeira`, `valor_para_parcelamento`, `plano_pagamento`, `taxa_financiamento`, `data_venda`, `parcela_entrada`, `lote_idlote`, `vencimento_restante`, `status_venda`, `cliente_idcliente2`, `entrada_restante`, `libera_proposta`, `igpm`, `centrocusto_id`, `contacorrente`, `valor_parcela_financiamento`, `valor_parcela_entrada`, `cadastrado_por`, `inter_periodo`, `inter_qtd`, `inter_valor`, `inter_data`, `spc`, `indice_aplic`, obs_sinal, obs_entrada) 
//                                                 VALUES ( '" . $venda['vendedor'] . "', '" . $venda['quadra'] . "', '" . $venda['cliente'] . "', '', '', '' , '" . $venda['valor_entrada'] . "', '" . $venda['vencimento_primeira'] . "', '', '" . $venda['num_parcela'] . "', '', '" . $venda['data_venda'] . "', '" . $venda['valor_primeira_parcela'] . "' , '" . $venda['lote'] . "', '', 4, 0,'',NULL,'', 2 , 0 ,'" . $venda['valor_parcela'] . "','',0,'','" . $venda['num_inter'] . "','" . $venda['valor_inter'] . "','" . $venda['primeira_inter'] . "', '" . $venda['cad_spc'] . "', 0, '', '')") or die(mysqli_error($db));

//                     //Rotina para pegar o ID do último elemento inserido na tabela venda, e insere na tabela propietario_lote.
//                     //$id_venda = mysqli_fetch_assoc(mysqli_query($db, "SELECT idvenda FROM venda ORDER BY idvenda DESC LIMIT 1")or die(mysqli_error($db)));

//                     if (mysqli_query($db, "SELECT idvenda FROM venda ORDER BY idvenda DESC LIMIT 1")) {
//                         $id_venda = mysqli_fetch_assoc(mysqli_query($db, "SELECT idvenda FROM venda ORDER BY idvenda DESC LIMIT 1"));
//                         $id_venda = $id_venda['idvenda'];
//                     } else {
//                         echo "id nao encontrado";
//                         die();
//                     }
//                     $cod_cessao = date('YmdHis') . $registro;

//                     $aux = mysqli_query($db, "INSERT INTO `proprietarios_lote`(`venda_id`, `cliente_id`, `percentual`, `cod_cessao`, `situacao_cessao`) VALUES ('$id_venda','" . $venda['cliente'] . "','100','$cod_cessao','1')") or die(mysqli_error($db));
//                     array_push($retorno['ok'], $registro);
//                 } else {

//                     // Insere as linha incorretas na tabela de erros
//                     for ($i = 0; $i <= count($linha); $i++) {
//                         if ($i == count($linha)) {
//                             $tabela_erro->setActiveSheetIndex(0)->setCellValue("" . $colunas[$i] . $aux_erro . "", $problema);
//                             break;
//                         }
//                         $tabela_erro->setActiveSheetIndex(0)->setCellValue("" . $colunas[$i] . $aux_erro . "", $linha[$i]);
//                     }
//                     $aux_erro++;

//                     $retorno["error"] = 1;
//                 }
//             }
//         }
//     }

//     $file = $objWriter = PHPExcel_IOFactory::createWriter($tabela_erro, 'Excel2007');
//     $file->save("planilhas/falhas.xlsx");

//     return $retorno;
// }

function grava_planilha_parcela($arquivo, $empreendimento)
{ // Passando o caminho do arquivo

    include_once "conexao.php";

    $retorno["ok"] = array();

    // If you need to parse XLS files, include_once php-excel-reader
    require('spreadsheet-reader-master/PHPExcel.php');
    require('spreadsheet-reader-master/php-excel-reader/excel_reader2.php');
    require('spreadsheet-reader-master/SpreadsheetReader.php');


    $tabela_erro = new PHPExcel();
    $colunas = ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X"];

    $Reader = new SpreadsheetReader($arquivo); // Crio o objeto do arquivo
    $Sheets = $Reader->Sheets(); // Obtenho as planilhas do arquivo

    foreach ($Sheets as $Index => $Name) { // Para percorrer as planilhas do arquivo

        $aux_erro = 2; // linha que eu começo a escrever na planilha de erro
        $Reader->ChangeSheet($Index);  // Habilito a página atual para edição

        foreach ($Reader as $registro => $linha) {  //Para percorrer as linhas dentro da planilha     

            if ($registro <= 4) {
                //Esse bloco verifica o titulo da planilha
                if ($registro == 0) {
                    $aux = 0;
                    foreach ($linha as $valor) {
                        if ($valor == "TABELA PARA CADASTRO DE PARCELAS") {
                            $aux = 1;
                        }
                    }
                    if ($aux !== 1) {
                        break;
                    }
                }

                if ($registro == 4) {
                    for ($i = 0; $i <= count($linha); $i++) {
                        if ($i == count($linha)) {
                            $tabela_erro->setActiveSheetIndex(0)->setCellValue("" . $colunas[$i] . "1", "Problema(s)");
                            break;
                        }
                        $tabela_erro->setActiveSheetIndex(0)->setCellValue("" . $colunas[$i] . "1", $linha[$i]);
                    }
                }

            } else {

                $cont = 0;
                //Verifico se a linha está completamente vazia 
                foreach ($linha as $valor) {
                    if (empty($valor)) {
                        $cont++;
                    } else {
                        break;
                    }
                }

	            //Se a linha estiver vazia o script para a varredura
	            if ($cont == 10) {
	                break;
	            }
	     
	                $problema = '';
	                $parcela;
	                $valida = 1;

	                for ($i = 0; $i < count($linha); $i++) {
	                    if ($i == 0) {
	                        if (empty($linha[$i])) {
	                            $problema = "Usuario não preenchido";
	                            $valida = 0;
	                            break;
	                        } else {
	                            if (consulta_cliente($linha[$i], $db)) {
	                                $parcela['usuario'] = $linha[$i];
	                            } else {
	                                $problema = "Usuario invalido";
	                                $valida = 0;
	                                break;
	                            }
	                        }
	                    } elseif ($i == 1) {
	                        if (empty($linha[$i])) {
	                            $problema = "Quadra não preenchido";
	                            $valida = 0;
	                            break;
	                        } else {
	                        	$parcela['empreendimento'] = consulta_empreendimento($empreendimento, $db);
	                            if (consulta_empreendimento($empreendimento, $db)) {
	                                if (consulta_quadra($empreendimento, $linha[$i], $db)) {
	                                    $parcela['quadra'] = consulta_quadra($empreendimento, $linha[$i], $db);
	                                } else {
	                                    $problema = "Quadra não Encontrado";
	                                    $valida = 0;
	                                    break;
	                                }
	                            } else {
	                                $problema = "Empreendimento não Encontrado";
	                            }
	                        }
	                    } elseif ($i == 2) {
	                        if (empty($linha[$i])) {
	                            $problema = "Lote não preenchido";
	                            $valida = 0;
	                            break;
	                        } else {
	                            if (consulta_empreendimento($empreendimento, $db)) {
	                                if (consulta_lote($empreendimento, $parcela['quadra'], $linha[$i], $db)) {
	                                    $parcela['lote'] = consulta_lote($empreendimento, $parcela['quadra'], $linha[$i], $db);
	                                } else {
	                                    $problema = "Lote não Encontrado";
	                                    $valida = 0;
	                                    break;
	                                }
	                            } else {
	                                $problema = "Empreendimento não Encontrado";
	                            }
	                        }
	                    } elseif ($i == 3) {
	                        if (empty($linha[$i])) {
	                            $problema = "Numero de sequencia não preenchido";
	                            $valida = 0;
	                            break;
	                        } else {
	                            $parcela['num_seq'] = $linha[$i];
	                        }
	                    } elseif ($i == 4) {
	                        if (!empty($linha[$i])) {
	                            $parcela['valor_parcela'] = formata_valor($linha[$i]);
	                        } else {
	                            $problema = "Valor da Parcela não preenchido";
	                            $valida = 0;
	                            break;
	                        }
	                    } elseif ($i == 5) {
	                        if (!empty($linha[$i])) {
	                            $parcela['data_vencimento'] = $linha[$i];
	                        } else {
	                            $problema = "Data do Vencimento não preenchido";
	                            $valida = 0;
	                            break;
	                        }
	                    } elseif ($i == 6) {
	                        if (!empty($linha[$i])) {
	                            $parcela['data_recebimento'] = $linha[$i];
	                        } else {
	                            $parcela['data_recebimento'] = '';
	                        }
	                    } elseif ($i == 7) {
	                        if (!empty($linha[$i])) {
	                            $parcela['valor_recebido'] = formata_valor($linha[$i]);
	                        } else {
	                            $parcela['valor_recebido'] = '';
	                        }
	                    } elseif ($i == 8) {
	                        if (!empty($linha[$i])) {
	                            $parcela['valor_desconto'] = formata_valor($linha[$i]);
	                        } else {
	                            $parcela['valor_desconto'] = '';
	                        }
	                    } elseif ($i == 9) {
	                        if (!empty($linha[$i])) {
	                            $parcela['valor_acrecimo'] = formata_valor($linha[$i]);
	                        } else {
	                            $parcela['valor_acrecimo'] = '';
	                        }
	                    }
	            	}

	            // echo "<pre>";
	            // var_dump($parcela);
	            // echo "<pre>";


	            // echo $valida;
	            // die();

	            // calculo outras variaveis para inserção no banco
	            if ($valida == 1) {

	                // consulto a venda
	                $super_aux = consulta_venda($parcela['lote'], $parcela['quadra'], $db);

	                if ($super_aux) {
	                    $parcela['id_venda'] = $super_aux;
	                    $parcela['cliente'] = consulta_cliente_venda($parcela['lote'], $parcela['quadra'], $db);

	                } else {
	                    $valida = 0;
	                    $problema .= 'Venda não encontrada !';
	                }

	                // consulto a situação
	                if ((!empty($parcela['valor_recebido'])) || (!empty($parcela['data_recebimento']))) {
	                    $parcela['situacao'] = 'Pago';
	                } else {
	                    $parcela['situacao'] = 'Em Aberto';
	                }

	                $super_aux = $parcela['empreendimento'];

	                //consulto o empreendimento_id_novo tabela parcelas
	                if ($super_aux !== 0) {
	                    $parcela['id_empreendimento'] = $super_aux;
	                } else {
	                    $parcela['id_empreendimento'] = '';
	                }
	            }

	            if ($valida == 1) {
	                //print_r($parcela);
	                //die();
	                /*
		            $aux1 = "INSERT INTO `parcelas`(`venda_idvenda`, `valor_parcelas`, `data_vencimento_parcela`, `situacao`, `descricao`, `remessa`, `data_remessa`, `tipo_venda`, `numero_sequencia`, `repasse_feito`, `data_recebimento`, `valor_recebido`, `desc_parcela`, `acre_parcela`, `forma_pagamento`, `fluxo`, `centrocusto_id`, `codigo_repasse`, `contacorrente_id`, `folhacheque_id`, `empreendimento_id_novo`, `cliente_id_novo`, `cod_baixa`, `obs_estorno`, `estornado_por`, `data_lancamento_sistema`, `lancamento_por`, `baixado_por`, `data_baixa`, `vinculo`, `data_boleto`,  `numero_boleto`, `juros_mora`, `juros_multa`, `juros_outros`, `obs_caldas`, `nosso_numero_old`, `obs_parcela`, `import_mora`, `import_multa`) 
		                VALUES ('".$parcela['id_venda']."','".$parcela['valor']."','".$parcela['vencimento']."','".$parcela['situacao']."','Financiamento', ".$parcela['remessa']." ,'', 2,'".$parcela['num_seq']."', 0,'".$parcela['pagamento']."','".$parcela['valor_pago']."','','','', 0, 0, 0, 0, 0, '".$parcela['id_empreendimento']."','".$parcela['cliente']."', 0, '', 0, '', 0, 1665, '".$parcela['data_baixa']."', '', '', '', '".$parcela['juros']."', '0','".$parcela['outros']."', '".$parcela['plano']."', '".$parcela['nosso_num']."', '".$parcela['obs']."', '".$parcela['mora']."', '".$parcela['multa']."' ) ";
		            */

	                $aux = mysqli_query($db, "INSERT INTO parcelas(venda_idvenda, valor_parcelas, data_vencimento_parcela, situacao, descricao, remessa, data_remessa, tipo_venda, numero_sequencia, repasse_feito, data_recebimento, valor_recebido, desc_parcela, acre_parcela, forma_pagamento, fluxo, centrocusto_id, codigo_repasse, contacorrente_id, folhacheque_id, empreendimento_id_novo, cliente_id_novo, cod_baixa, obs_estorno, estornado_por, data_lancamento_sistema, lancamento_por, baixado_por, data_baixa, vinculo, data_boleto, numero_boleto, juros_mora, juros_multa, juros_outros, obs_caldas, nosso_numero_old, obs_parcela, import_mora, import_multa, cab) VALUES ('".$parcela['id_venda']."', '".$parcela['valor_parcela']."', '".$parcela['data_vencimento']."', '".$parcela['situacao']."', '', '', '', 2, '".$parcela['num_seq']."', '', '".$parcela['data_recebimento']."', '".$parcela['valor_recebido']."', '".$parcela['valor_desconto']."', '".$parcela['valor_acrecimo']."', '', '', '', '', '', '', '".$parcela['id_empreendimento']."', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '')") or die(mysqli_error($db));


	                	// ('" . $parcela['id_venda'] . "','" . $parcela['valor'] . "','" . $parcela['vencimento'] . "','" . $parcela['situacao'] . "','Financiamento', " . $parcela['remessa'] . " ,'', 2,'" . $parcela['num_seq'] . "', 0,'" . $parcela['pagamento'] . "','" . $parcela['valor_pago'] . "','','','', 0, 0, 0, 0, 0, '" . $parcela['id_empreendimento'] . "','" . $parcela['cliente'] . "', 0, '', 0, '', 0, 1665, '" . $parcela['data_baixa'] . "', '', '', '', '" . $parcela['juros'] . "', '0' ,'" . $parcela['outros'] . "', '" . $parcela['plano'] . "', '" . $parcela['nosso_num'] . "', '" . $parcela['obs'] . "', '" . $parcela['mora'] . "', '" . $parcela['multa'] . "' ) ") or die(mysqli_error($db));

	                array_push($retorno['ok'], $registro);
	            } else {

	                // Insere as linha incorretas na tabela de erros
	                for ($i = 0; $i <= count($linha); $i++) {
	                    if ($i == count($linha)) {
	                        $tabela_erro->setActiveSheetIndex(0)->setCellValue("" . $colunas[$i] . $aux_erro . "", $problema);
	                        break;
	                    }
	                    $tabela_erro->setActiveSheetIndex(0)->setCellValue("" . $colunas[$i] . $aux_erro . "", $linha[$i]);
	                }
	                $aux_erro++;

	                $retorno["error"] = 1;
	            }
        	}
        }
    }


    $file = $objWriter = PHPExcel_IOFactory::createWriter($tabela_erro, 'Excel2007');
    $file->save("planilhas/falhas.xlsx");

    if (isset($retorno['ok'])) {
        echo "\nLINHAS GRAVADAS: " . count($retorno['ok']);
    } elseif (isset($retorno['error'])) {
        echo "\n\nLINHAS NÃO GRAVADAS: " . count($retorno['error']);
    }

    return $retorno;
}

?>